#include "HT1621.h"

#define ADDR_MAX 128

#define TAKE_CS()    _cs = 0
#define RELEASE_CS() _cs = 1

HT1621::HT1621(
    PinName data, PinName wr, PinName rd, PinName cs
    ):
    _data(data), _wr(wr), _rd(rd), _cs(cs)
{
    _data.output();
    _data = 1;
    _wr = 1;
    _rd = 1;
    _cs = 1;
    sendCommand(SYS_DIS);
    wait_ms(500);
    //if (! testMem())
    //    return false;

    memset(0, 0, ADDR_MAX);
    sendCommand(SYS_EN);
    sendCommand(LCD_ON);
}


inline bool HT1621::testMem()
{
    uint8_t test = 10;
    writeMem(0x5a, test);
    if (readMem(0x5a) != test)
        return false;
    return true;
}


void HT1621::writeBits(uint8_t data, uint8_t cnt)
{
    while (cnt) {
        _wr = 0;
        uint8_t bitval = (data & (1 << (cnt - 1))) ? 1 : 0;
        _data = bitval;
        //wait_ms(1);
        _wr = 1;
        cnt--;
    }
}

uint8_t HT1621::readBits(uint8_t cnt)
{
    uint8_t data = 0;
    _data.input();
    while (cnt) {
        _rd = 0;
        data += _data << (cnt - 1);
        //wait_ms(1);
        _rd= 1;
        cnt--;
    }
    _data.output();
    return data;
}

#define COMMAND_MODE 0b100
void HT1621::sendCommand(uint8_t cmd, bool first /*= true*/, bool last /*= true*/)
{
    if (first) {
        TAKE_CS();
        writeBits(COMMAND_MODE, 3);
    }
    writeBits(cmd, 8);
    writeBits(0, 1); //Last bit - don't care
    if (last)
        RELEASE_CS();
}

#define WRITE_MODE 0b101
void HT1621::writeMem(uint8_t address, uint8_t data)
{
    TAKE_CS();
    writeBits(WRITE_MODE, 3);
    writeBits(address, 6);
    writeBits(data, 4);
    RELEASE_CS();
}

void HT1621::memset(uint8_t address, uint8_t data, uint8_t cnt)
{
  TAKE_CS();
  writeBits(WRITE_MODE, 3);
  writeBits(address, 6);
  for (uint8_t i = 0; i < cnt; i++)
    writeBits(data, 4);
  RELEASE_CS();
}

//Write up to 256 values starting from address
//Note: Data is 8-bit aligned. This is not vary efficient
void HT1621::write(uint8_t address, uint8_t *data, uint8_t cnt)
{
    TAKE_CS();
    writeBits(WRITE_MODE, 3);
    writeBits(address, 6);
    for (uint8_t i = 0; i < cnt; i++)
        writeBits(data[i], 4);
    RELEASE_CS();
}

#define READ_MODE 0b110
uint8_t HT1621::readMem(uint8_t address)
{
    uint8_t data;
    TAKE_CS();
    writeBits(READ_MODE, 3);
    writeBits(address, 6);
    data = readBits(4);
    RELEASE_CS();
    return data;
}

#define READ_MODE 0b110
void HT1621::read(uint8_t address, uint8_t *data, uint8_t cnt)
{
    TAKE_CS();
    writeBits(READ_MODE, 3);
    writeBits(address, 6);
    for (uint8_t i = 0; i < cnt; i++)
        data[i] = readBits(4);
    RELEASE_CS();
}
