/*
16bbit 80mode

reference


*/
#ifndef MBED_HD6676_H
#define MBED_HD66766_H
// register names from Peter Barrett's Microtouch code
#include "mbed.h"

#define swap(a, b) { int16_t t = a; a = b; b = t; }

class HD66766
{
public:
    HD66766(
    PinName rd, PinName wr, PinName rs, PinName cs, PinName rst,
    PinName d0, PinName d1, PinName d2, PinName d3,
    PinName d4, PinName d5, PinName d6, PinName d7,
    PinName d8, PinName d9, PinName d10, PinName d11,
    PinName d12, PinName d13, PinName d14, PinName d15
    );
    ~HD66766(){};

    size_t println(char *c); 

    uint16_t Color565(uint8_t r, uint8_t g, uint8_t b);

    // drawing primitives!
    void drawPixel(uint16_t x, uint16_t y, uint16_t color);
    void fillScreen(uint16_t color);
    void drawLine(int16_t x0, int16_t y0, int16_t x1, int16_t y1, uint16_t color);
    void drawVerticalLine(uint16_t x0, uint16_t y0, uint16_t length, uint16_t color);
    void drawHorizontalLine(uint16_t x0, uint16_t y0, uint16_t length, uint16_t color);
    void drawTriangle(uint16_t x0, uint16_t y0,
              uint16_t x1, uint16_t y1,
              uint16_t x2, uint16_t y2, uint16_t color);
    void fillTriangle(int32_t x0, int32_t y0,
              int32_t x1, int32_t y1,
            int32_t x2, int32_t y2, 
            uint16_t color);
    void drawRect(uint16_t x0, uint16_t y0, uint16_t w, uint16_t h, uint16_t color);
    void fillRect(uint16_t x0, uint16_t y0, uint16_t w, uint16_t h, uint16_t color);
    void drawRoundRect(uint16_t x0, uint16_t y0, uint16_t w, uint16_t h, uint16_t radius, uint16_t color);
    void fillRoundRect(uint16_t x0, uint16_t y0, uint16_t w, uint16_t h, uint16_t radius, uint16_t color);
    void drawCircle(uint16_t x0, uint16_t y0, uint16_t r, uint16_t color);
    void fillCircle(uint16_t x0, uint16_t y0, uint16_t r, uint16_t color);

    void setCursor(uint16_t x, uint16_t y);
    void setTextColor(uint16_t c);
    void setTextSize(uint8_t s);
    virtual size_t write(uint8_t);

    void drawChar(uint16_t x, uint16_t y, char c, uint16_t color, uint8_t s = 1);
    void drawString(uint16_t x, uint16_t y, char *c, uint16_t color, uint8_t s = 1);
    
    // commands
    void reset(void);
    void initDisplay(void);
    void goHome(void);
    void goTo(uint16_t x, uint16_t y);

    // low level
    void writeData(uint16_t data) {
        _write(1, data);
    };
    void writeCommand(uint16_t data) {
        _write(0, data);
    };
    uint16_t readData(void);
    uint16_t readRegister(uint16_t addr);
    void writeRegister(uint16_t addr, uint16_t data);

    uint16_t width();
    uint16_t height();
    static const uint16_t LCDWIDTH = 128;
    static const uint16_t LCDHEIGHT = 176;

    void writeData_unsafe(uint16_t d);

    void setWriteDir(void);
    void setReadDir(void);

    void mirror(uint16_t d);
    uint16_t rb_swap(uint16_t c);
private:

    DigitalOut _rd, _wr, _rs, _cs, _rst;
    BusInOut  _d;
    void _write(uint16_t rs, uint16_t d);
    uint16_t _width, _height;
    uint16_t _gramstart;
    uint16_t _rb_swap;
    uint16_t cursor_x, cursor_y;
    uint8_t textsize;
    uint16_t textcolor;
    void drawCircleHelper(uint16_t x0, uint16_t y0, uint16_t r, uint8_t corner, uint16_t color);
    void fillCircleHelper(uint16_t x0, uint16_t y0, uint16_t r, uint8_t corner, uint16_t delta, uint16_t color);
    void _delay(uint16_t t);
};
#endif
