/**
http://suz-avr.sblo.jp/article/37364983.html
http://elegadget.blog.fc2.com/blog-entry-5.html
http://stm32f4.web.fc2.com/STM32F1/momiji_LCD018.html

ARCH PRO:   D14, D15 Open Drain port, need pull up R.
NUCLEO:     D0, D1 assigned UART port.

not support rotation.
**/

#include "mbed.h"
#include "HD66766.h"

#define DEBUG   0

#define BLACK           0x0000
#define BLUE            0x001F
#define RED             0xF800
#define GREEN           0x07E0
#define CYAN            0x07FF
#define MAGENTA         0xF81F
#define YELLOW          0xFFE0 
#define WHITE           0xFFFF


#if defined(TARGET_ARCH_PRO)
HD66766 lcd(A0, A1, A2, A3, A4,
    D0, D1, D2, D3, D4, D5, D6, D7,
    D8, D9, D10, D11, D12, D13, D14, D15);
Serial pc(USBTX, USBRX);
//#elif defined TARGET_NUCLEO_F103RB
//HD66766 lcd(A0, A1, A2, A3, A4,
//    D0, D1, D2, D3, D4, D5, D6, D7,
//    D8, D9, D10, D11, D12, D13, D14, D15);
//Serial pc(SERIAL_TX, SERIAL_RX);
//#elif defined TARGET_NUCLEO_F446RE
//HD66766 lcd(A0, A1, A2, A3, A4,
//    D0, D1, D2, D3, D4, D5, D6, D7,
//    D8, D9, D10, D11, D12, D13, D14, D15);
//Serial pc(SERIAL_TX, SERIAL_RX);

#endif
void testText() {
        lcd.fillScreen(BLACK);
        lcd.setCursor(0, 30);
        lcd.setTextColor(RED);
        lcd.setTextSize(1);
        lcd.println("Hello World!\n");
        wait_ms(500);
        lcd.setTextColor(YELLOW);
        lcd.setTextSize(2);
        lcd.println("Hello World!\n");
        wait_ms(500);
        lcd.setTextColor(GREEN);
        lcd.setTextSize(3);
        lcd.println("Hello World!\n");
        wait_ms(500);
        lcd.setTextColor(CYAN);
        lcd.setTextSize(3);
        lcd.println("Hello World!\n");
        wait_ms(500);
        lcd.setTextColor(MAGENTA);
        lcd.setTextSize(2);
        lcd.println("Hello World!\n");
        wait_ms(500);
        lcd.setTextColor(WHITE);
        lcd.setTextSize(1);
        lcd.println("Hello World!\n");
        wait_ms(500);
        lcd.setTextColor(BLUE);
        lcd.setTextSize(1);
        lcd.println("1234.567\n");
        wait_ms(500);

 }

void testfillcircles(uint8_t radius, uint16_t color) {
  for (uint16_t x=radius; x < lcd.width(); x+=radius*2) {
    for (uint16_t y=radius; y < lcd.height(); y+=radius*2) {
      lcd.fillCircle(x, y, radius, color);
    }
  }  
}

void testdrawcircles(uint8_t radius, uint16_t color) {
  for (uint16_t x=0; x < lcd.width()+radius; x+=radius*2) {
    for (uint16_t y=0; y < lcd.height()+radius; y+=radius*2) {
      lcd.drawCircle(x, y, radius, color);
    }
  }  
}

void testfillrects(uint16_t color1, uint16_t color2) {
 lcd.fillScreen(BLACK);
 for (uint16_t x=lcd.width()-1; x > 6; x-=6) {
   //Serial.println(x, DEC);
   lcd.fillRect(lcd.width()/2 -x/2, lcd.height()/2 -x/2 , x, x, color1);
   lcd.drawRect(lcd.width()/2 -x/2, lcd.height()/2 -x/2 , x, x, color2);
 }
}

void testdrawrects(uint16_t color) {
 lcd.fillScreen(BLACK);
 for (uint16_t x=0; x < lcd.width(); x+=6) {
   //pc.printf("%d\r\n", x);
   lcd.drawRect(lcd.width()/2 -x/2, lcd.height()/2 -x/2 , x, x, color);
 }
}

void testFillRoundRect() {
  lcd.fillScreen(RED);
  
  for (uint16_t x=lcd.width(); x > 20 ; x-=6) {
    lcd.fillRoundRect(lcd.width()/2 -x/2, lcd.height()/2 -x/2 , x, x, x/8,  lcd.Color565(0, x<<1, 0));
 }
}

void testfilltriangles() {
  lcd.fillScreen(BLACK);
  
  for (uint16_t i=lcd.width()/2; i>10; i-=5) {
    lcd.fillTriangle(lcd.width()/2, lcd.height()/2-i,
                     lcd.width()/2-i, lcd.height()/2+i,
                     lcd.width()/2+i, lcd.height()/2+i, 
                     BLUE);
    lcd.drawTriangle(lcd.width()/2, lcd.height()/2-i,
                     lcd.width()/2-i, lcd.height()/2+i,
                     lcd.width()/2+i, lcd.height()/2+i, GREEN);    
  }
}

void testtriangles() {
  lcd.fillScreen(BLACK);
  for (uint16_t i=0; i<lcd.width()/2; i+=5) {
    lcd.drawTriangle(lcd.width()/2, lcd.height()/2-i,
                     lcd.width()/2-i, lcd.height()/2+i,
                     lcd.width()/2+i, lcd.height()/2+i, YELLOW);
  }
/*
  lcd.fillScreen(BLACK);
  for (uint16_t i=0; i<lcd.width()/2; i+=5) {
    lcd.drawTriangle(lcd.width()/2, lcd.height()/2-i,
                     lcd.width()/2-i, lcd.height()/2+i,
                     lcd.width()/2+i, lcd.height()/2+i, lcd.Color565(0, i, 0));
  }
  lcd.fillScreen(BLACK);
  for (uint16_t i=0; i<lcd.width()/2; i+=5) {
    lcd.drawTriangle(lcd.width()/2, lcd.height()/2-i,
                     lcd.width()/2-i, lcd.height()/2+i,
                     lcd.width()/2+i, lcd.height()/2+i, lcd.Color565(i, 0, 0));
  }
*/
}

void testfastlines(uint16_t color1, uint16_t color2) {
   lcd.fillScreen(BLACK);
   for (uint16_t y=0; y < lcd.height(); y+=4) {
   //  pc.printf("%d\r\n", y);
     lcd.drawHorizontalLine(0, y, lcd.width(), color1);
   }
   for (uint16_t x=0; x < lcd.width(); x+=4) {
   //  pc.printf("%d\r\n", x);
     lcd.drawVerticalLine(x, 0, lcd.height(), color2);
   }
  
}

void testlines(uint16_t color) {
   lcd.fillScreen(BLACK);
   for (uint16_t x=0; x < lcd.width(); x+=6) {
     lcd.drawLine(0, 0, x, lcd.height()-1, color);
   }
   for (uint16_t y=0; y < lcd.height(); y+=6) {
     lcd.drawLine(0, 0, lcd.width()-1, y, color);
   }
   
   lcd.fillScreen(BLACK);
   for (uint16_t x=0; x < lcd.width(); x+=6) {
     lcd.drawLine(lcd.width()-1, 0, x, lcd.height()-1, color);
   }
   for (uint16_t y=0; y < lcd.height(); y+=6) {
     lcd.drawLine(lcd.width()-1, 0, 0, y, color);
   }
   
   lcd.fillScreen(BLACK);
   for (uint16_t x=0; x < lcd.width(); x+=6) {
     lcd.drawLine(0, lcd.height()-1, x, 0, color);
   }
   for (uint16_t y=0; y < lcd.height(); y+=6) {
     lcd.drawLine(0, lcd.height()-1, lcd.width()-1, y, color);
   }

   lcd.fillScreen(BLACK);
   for (uint16_t x=0; x < lcd.width(); x+=6) {
     lcd.drawLine(lcd.width()-1, lcd.height()-1, x, 0, color);
   }
   for (uint16_t y=0; y < lcd.height(); y+=6) {
     lcd.drawLine(lcd.width()-1, lcd.height()-1, 0, y, color);
   }
}

void testBars() {
    //for (int id = 0x0000; id <= 0x0007; id++) {
    //lcd.writeRegister(0x0005, id<<3); // Entry Mode
    lcd.goHome();

    uint16_t i,j;
    lcd.writeCommand(0x0022);
    for(i=0; i < lcd.height(); i++)
    {
        for(j=0; j < 64; j++)
        {
            if (i>79) lcd.writeData(BLACK);
            //else if(i>239) lcd.writeData(YELLOW);
            //else if(i>199) lcd.writeData(MAGENTA);
            //else if(i>159) lcd.writeData(RED);
            //else if(i>119) lcd.writeData(CYAN);
            //else if(i>79) lcd.writeData(GREEN);
            //else if(i>39) lcd.writeData(BLUE);
            else lcd.writeData(WHITE);
            //wait_ms(1);
        }
        for(j=0; j < 64; j++)
        {
            if (i>139) lcd.writeData(WHITE);
            else if(i>119) lcd.writeData(BLUE);
            else if(i>99) lcd.writeData(GREEN);
            else if(i>79) lcd.writeData(CYAN);
            else if(i>59) lcd.writeData(RED);
            else if(i>39) lcd.writeData(MAGENTA);
            else if(i>19) lcd.writeData(YELLOW);
            else lcd.writeData(BLACK);
            //wait_ms(1);
        }
    }
    //wait(5);
    //}
}
char BUF[16];
main()
{
    wait(1);
    uint16_t  identifier = lcd.readRegister(0x0);
    uint16_t c, y;
    uint16_t mode;
    if (identifier == 0x0766) {
        pc.printf("Found HD66766\n");
    } else {
        pc.printf("Unknown driver chip %X\n",identifier);
        while (1);
    } 
    lcd.initDisplay();
    mode = 0;
    while(1){
        //lcd.mirror(1);
        switch(mode) {
            case 0: {
                testText();
                testBars();
                wait(1);
                break;
            }
            case 1: {
                testfastlines(CYAN, MAGENTA);
                break;
            }
            case 2: {
                testtriangles();
                testfilltriangles();
                break;
            }
            case 3: {
                testfillcircles(50, RED);
                lcd.fillScreen(BLACK);
                testdrawcircles(10, YELLOW);
                break;
            }
            case 4: {
                testdrawrects(GREEN);
                testlines(BLUE);
                testfillrects(RED, WHITE);
                testFillRoundRect();
                testdrawrects(GREEN);
                break;
            }
            case 5: {
                lcd.fillScreen(BLACK);
                lcd.setTextColor(WHITE);
                lcd.setTextSize(1);
                lcd.drawPixel(0,0,WHITE);
                lcd.setCursor(5, 0);
                for (y = 0; y < 176; y ++) {
                    if (y > 140) {
                    sprintf(BUF, "%d\n", y);
                    lcd.println(BUF);
                    }
                    if (y % 10 == 0 ) c = CYAN;
                    else c = YELLOW;
                    lcd.drawPixel(0, y, c);
                    wait_ms(100);
                }
                lcd.fillScreen(RED);
                wait(1);
                lcd.fillScreen(GREEN);
                wait(1);
                lcd.fillScreen(BLUE);
                wait(1);
                lcd.fillScreen(WHITE);
                wait(1);
                break;
            }

        }
        mode++;
    }
}