/**
** http://www.aitendo.com/product/10942
** HX8347D

https://github.com/adafruit/TFTLCD-Library/tree/master/bitmaps

**/

#include "mbed.h"
#include "HX8347D.h"
#include "SDFileSystem.h"
//#define ROW  320
//#define COL 240

#define BLACK           0x0000
#define BLUE            0x001F
#define RED             0xF800
#define GREEN           0x07E0
#define CYAN            0x07FF
#define MAGENTA         0xF81F
#define YELLOW          0xFFE0 
#define WHITE           0xFFFF

#if defined(TARGET_ARCH_PRO)
HX8347D tft(A0, A1, A2, A3, A4, D2, D3, D4, D5, D6, D7, D8, D9);
SDFileSystem sd(D11, D12, D13, D10, "sd"); // mosi miso sclk cs
Serial pc(USBTX, USBRX);
#elif defined(TARGET_LPC1768)
HX8347D tft(p15, p16, p17, p18, p19, p8, p26, p25, p24, p23, p10, p9, p22);
Serial pc(USBTX, USBRX);
SDFileSystem sd(p5, p6, p7, p21, "sd"); // mosi miso sclk cs
#elif defined TARGET_NUCLEO_F446RE
/* D0, D1 short SB62,SB63*/
HX8347D tft(A0, A1, A2, A3, A4, D2, D3, D4, D5, D6, D7, D8, D9);
SDFileSystem sd(D11, D12, D13, D10, "sd"); // mosi miso sclk cs
Serial pc(USBTX, USBRX);

#elif defined TARGET_NUCLEO_F103RB
/* D0, D1 short SB62,SB63*/
// SPI_MOSI D11
// SPI_MISO D12
// SPI_SCK  D13
// SPI_CS   D10
HX8347D tft(A0, A1, A2, A3, A4, D2, D3, D4, D5, D6, D7, D8, D9);
SDFileSystem sd(D11, D12, D13, D10, "sd"); // mosi miso sclk cs
Serial pc(USBTX, USBRX);


#endif

char str[128];

void rotateTest() {
    tft.setRotation(1);
    for (uint16_t y=0; y < tft.height(); y+=5) {
        tft.drawHorizontalLine(0, y, tft.width(), RED);
    }
    wait_ms(500);
    for (uint16_t x=0; x < tft.width(); x+=5) {
        tft.drawVerticalLine(x, 0, 239, GREEN);
        pc.printf("x=%d  %d\n", x, tft.height());
    }
    wait_ms(500);
    
}
void rotateText() {
    for (uint8_t i=0; i<4; i++) {
        tft.fillScreen(BLACK);
        pc.printf("%d" , tft.getRotation());
        
        tft.setCursor(0, 30);
        tft.setTextColor(RED);
        tft.setTextSize(1);
        tft.println("Hello World!\n");
        wait_ms(500);
        tft.setTextColor(YELLOW);
        tft.setTextSize(2);
        tft.println("Hello World!\n");
        wait_ms(500);
        tft.setTextColor(GREEN);
        tft.setTextSize(3);
        tft.println("Hello World!\n");
        wait_ms(500);
        tft.setTextColor(CYAN);
        tft.setTextSize(3);
        tft.println("Hello World!\n");
        wait_ms(500);
        tft.setTextColor(MAGENTA);
        tft.setTextSize(2);
        tft.println("Hello World!\n");
        wait_ms(500);
        tft.setTextColor(WHITE);
        tft.setTextSize(1);
        tft.println("Hello World!\n");
        wait_ms(500);
        tft.setTextColor(BLUE);
        tft.setTextSize(1);
        tft.println("1234.567\n");
        wait_ms(500);

        tft.setRotation(tft.getRotation()+1);
    }
}


void testtext(uint16_t color) {
    tft.fillScreen(BLACK);
    tft.setCursor(0, 0);
    tft.setTextColor(color);
    tft.setTextSize(1);
    tft.drawString(0, 20, "Hello aitendo!", color);
    wait_ms(500);
    tft.drawChar(0, 50, '1', YELLOW, 1);
    tft.write('A');
    //wait_ms(500);
    tft.setCursor(0, 100);
    tft.println("Hello aitendo!\n");
    //wait_ms(500);
    tft.setCursor(0, 150);
    tft.setTextSize(3);
    tft.println("1234.56");
    //wait_ms(500);
    tft.setCursor(0, 200);
    tft.setTextSize(3);
    sprintf(str, "%X", 0xDEADBEEF);
    tft.println(str);
    wait_ms(500);
}

void testFillRoundRect() {
  tft.fillScreen(RED);
  
  for (uint16_t x=tft.width(); x > 20 ; x-=6) {
    tft.fillRoundRect(tft.width()/2 -x/2, tft.height()/2 -x/2 , x, x, x/8,  tft.Color565(0, x, 0));
 }
}

void testtriangles() {
  tft.fillScreen(BLACK);
  for (uint16_t i=0; i<tft.width()/2; i+=5) {
    tft.drawTriangle(tft.width()/2, tft.height()/2-i,
                     tft.width()/2-i, tft.height()/2+i,
                     tft.width()/2+i, tft.height()/2+i, tft.Color565(0, 0, i));
  }
  tft.fillScreen(BLACK);
  for (uint16_t i=0; i<tft.width()/2; i+=5) {
    tft.drawTriangle(tft.width()/2, tft.height()/2-i,
                     tft.width()/2-i, tft.height()/2+i,
                     tft.width()/2+i, tft.height()/2+i, tft.Color565(0, i, 0));
  }
  tft.fillScreen(BLACK);
  for (uint16_t i=0; i<tft.width()/2; i+=5) {
    tft.drawTriangle(tft.width()/2, tft.height()/2-i,
                     tft.width()/2-i, tft.height()/2+i,
                     tft.width()/2+i, tft.height()/2+i, tft.Color565(i, 0, 0));
  }
}

void testfilltriangles() {
  tft.fillScreen(BLACK);
  
  for (uint16_t i=tft.width()/2; i>10; i-=5) {
    tft.fillTriangle(tft.width()/2, tft.height()/2-i,
                     tft.width()/2-i, tft.height()/2+i,
                     tft.width()/2+i, tft.height()/2+i, 
                     tft.Color565(0, i, i));
    tft.drawTriangle(tft.width()/2, tft.height()/2-i,
                     tft.width()/2-i, tft.height()/2+i,
                     tft.width()/2+i, tft.height()/2+i, tft.Color565(i, i, 0));    
  }
}
void testfillcircles(uint8_t radius, uint16_t color) {
  for (uint16_t x=radius; x < tft.width(); x+=radius*2) {
    for (uint16_t y=radius; y < tft.height(); y+=radius*2) {
      tft.fillCircle(x, y, radius, color);
    }
  }  
}

void testdrawcircles(uint8_t radius, uint16_t color) {
  for (uint16_t x=0; x < tft.width()+radius; x+=radius*2) {
    for (uint16_t y=0; y < tft.height()+radius; y+=radius*2) {
      tft.drawCircle(x, y, radius, color);
    }
  }  
}

void testfillrects(uint16_t color1, uint16_t color2) {
 tft.fillScreen(BLACK);
 for (uint16_t x=tft.width()-1; x > 6; x-=6) {
   //Serial.println(x, DEC);
   tft.fillRect(tft.width()/2 -x/2, tft.height()/2 -x/2 , x, x, color1);
   tft.drawRect(tft.width()/2 -x/2, tft.height()/2 -x/2 , x, x, color2);
 }
}

void testdrawrects(uint16_t color) {
 tft.fillScreen(BLACK);
 for (uint16_t x=0; x < tft.width(); x+=6) {
   //pc.printf("%d\r\n", x);
   tft.drawRect(tft.width()/2 -x/2, tft.height()/2 -x/2 , x, x, color);
 }
}

void testfastlines(uint16_t color1, uint16_t color2) {
   tft.fillScreen(BLACK);
   for (uint16_t y=0; y < tft.height(); y+=5) {
   //  pc.printf("%d\r\n", y);
     tft.drawHorizontalLine(0, y, tft.width(), color1);
   }
   for (uint16_t x=0; x < tft.width(); x+=5) {
   //  pc.printf("%d\r\n", x);
     tft.drawVerticalLine(x, 0, tft.height(), color2);
   }
  
}


void testlinerotate() {
    uint16_t color1;
    uint16_t color2;
    uint8_t n;
    for (uint8_t i=0; i<4; i++) {
        tft.fillScreen(BLACK);
        n = 3+i*4;
        tft.setCursor(0, 10);
        tft.setTextSize(1);
        color1 = tft.Color565(n, 0, 0);
        color2 = tft.Color565(0, 0, n);
        color1 = BLUE;
        color2 = RED;
        sprintf(str, "%X\n", color1);
        tft.println(str);
        sprintf(str, "%X\n", color2);
        tft.println(str);
        for (uint16_t y=0; y < tft.height(); y+=5) {
            tft.drawHorizontalLine(0, y, tft.width(), color1);
            //pc.printf("y=%d  %d\n", y, tft.height());
        }
        //wait_ms(500);
        for (uint16_t x=0; x < tft.width(); x+=5) {
            tft.drawVerticalLine(x, 0, tft.height(), color2);
            //pc.printf("x=%d  %d\n", x, tft.height());
        }
        tft.setRotation(tft.getRotation()+1);
        //wait_ms(500);
    }
}

void testlines(uint16_t color) {
   tft.fillScreen(BLACK);
   for (uint16_t x=0; x < tft.width(); x+=6) {
     tft.drawLine(0, 0, x, tft.height()-1, color);
   }
   for (uint16_t y=0; y < tft.height(); y+=6) {
     tft.drawLine(0, 0, tft.width()-1, y, color);
   }
   
   tft.fillScreen(BLACK);
   for (uint16_t x=0; x < tft.width(); x+=6) {
     tft.drawLine(tft.width()-1, 0, x, tft.height()-1, color);
   }
   for (uint16_t y=0; y < tft.height(); y+=6) {
     tft.drawLine(tft.width()-1, 0, 0, y, color);
   }
   
   tft.fillScreen(BLACK);
   for (uint16_t x=0; x < tft.width(); x+=6) {
     tft.drawLine(0, tft.height()-1, x, 0, color);
   }
   for (uint16_t y=0; y < tft.height(); y+=6) {
     tft.drawLine(0, tft.height()-1, tft.width()-1, y, color);
   }

   tft.fillScreen(BLACK);
   for (uint16_t x=0; x < tft.width(); x+=6) {
     tft.drawLine(tft.width()-1, tft.height()-1, x, 0, color);
   }
   for (uint16_t y=0; y < tft.height(); y+=6) {
     tft.drawLine(tft.width()-1, tft.height()-1, 0, y, color);
   }
}

void testBars() {
  tft.goHome();

  uint16_t i,j;
  for(i=0; i < tft.height(); i++)
  {
    for(j=tft.width()/2; j <tft.width(); j++)
    {
      if(i>279) tft.writeData(WHITE);
      else if(i>239) tft.writeData(BLUE);
      else if(i>199) tft.writeData(GREEN);
      else if(i>159) tft.writeData(CYAN);
      else if(i>119) tft.writeData(RED);
      else if(i>79) tft.writeData(MAGENTA);
      else if(i>39) tft.writeData(YELLOW);
      else tft.writeData(BLACK);
      //wait_ms(5);
    }
    for(j=0; j < tft.width()/2; j++)
    {
      if(i>159) tft.writeData(BLACK);
      //else if(i>239) tft.writeData(YELLOW);
      //else if(i>199) tft.writeData(MAGENTA);
      //else if(i>159) tft.writeData(RED);
      //else if(i>119) tft.writeData(CYAN);
      //else if(i>79) tft.writeData(GREEN);
      //else if(i>39) tft.writeData(BLUE);
      else tft.writeData(WHITE);
      //wait_ms(1);
    }
  }
}

/**


**/

// information we extract about the bitmap file
int bmpWidth, bmpHeight;
uint8_t bmpDepth, bmpImageoffset;

#define ROTATION 3
#define BUFFPIXEL 60
#define BYTES_PER_PIXEL 3

uint8_t picBuffer[BYTES_PER_PIXEL * BUFFPIXEL];  // 3 * pixels to buffer
int bufferIndex = BYTES_PER_PIXEL * BUFFPIXEL;

char path[80];

// These read data from the SD card file and convert them to big endian 
// (the data is stored in little endian format!)


// LITTLE ENDIAN!

uint16_t read16(FILE *f) {
  uint16_t d;
  uint8_t b;
  fread(&b, sizeof(uint8_t), 1, f);
  fread(&d, sizeof(uint8_t), 1, f);
  d <<= 8;
  d |= b;
  return d;
}


// LITTLE ENDIAN!
uint32_t read32(FILE *f) {
  uint32_t d;
  uint16_t b;
 
  b = read16(f);
  d = read16(f);
  d <<= 16;
  d |= b;
  return d;
}

/*
  From example code.  Reads bitmap header.  Uses global variables.

*/
bool bmpReadHeader(FILE *f) {
   // read header
  uint32_t tmp;
  
  if (read16(f) != 0x4D42) {
    // magic bytes missing
    return false;
  }
 
  // read file size
  tmp = read32(f);  
  pc.printf("size 0x %X\n", tmp);
  
  // read and ignore creator bytes
  read32(f);
  
  bmpImageoffset = read32(f);  
  pc.printf("offset %d\n", bmpImageoffset);
  
  // read DIB header
  tmp = read32(f);
  pc.printf("header size %d\n", tmp);
  bmpWidth = read32(f);
  bmpHeight = read32(f);

  
  if (read16(f) != 1)
    return false;
    
  bmpDepth = read16(f);
  pc.printf("bitdepth %d\n", bmpDepth);


  pc.printf("compression %d\n", tmp);

  return true;
}

/*
 Slightly modified routine for drawing bitmaps (From original samples).
 
 Watch out, as this one uses some global variables
*/
void bmpdraw(FILE *f, int x, int y) {
  fseek(f, bmpImageoffset, SEEK_SET);
    
  uint16_t p;
  int i, j;
 
  pc.printf("rotation = %d\n", tft.getRotation());
  
  tft.goTo(0,0);
  for (i=0; i< bmpHeight; i++) {
    // bitmaps are stored with the BOTTOM line first so we have to move 'up'
    tft.goTo(0, bmpHeight - i - 1);

    for (j=0; j<bmpWidth; j++) {
      // read more pixels

      if (bufferIndex >= BYTES_PER_PIXEL * BUFFPIXEL) {
        fread(&picBuffer, sizeof(uint8_t), BYTES_PER_PIXEL * BUFFPIXEL, f);
        bufferIndex= 0;
      }
      
      p = tft.Color565( picBuffer[bufferIndex+2], picBuffer[bufferIndex+1], picBuffer[bufferIndex]);
      bufferIndex += 3;

      tft.writeData(p);
    }
  }
}


FILE *fp;

main()
{
    wait(1);

    #if defined TARGET_NUCLEO_F103RB
    //SystemClock_Config_INT();
    #endif
    //char bmpFile[80];
    DIR *dir;

    tft.reset();
    
    // find the TFT display
    uint16_t identifier = tft.readRegister(0x0);
    if (identifier == 0x4747) {
        pc.printf("Found HX8347D\n");
    } else {
        pc.printf("Unknown driver chip %X\n",identifier);
        while (1);
    }  
    
    tft.initDisplay();
    
    pc.printf("Initializing SD card...\n");
    
    dir = opendir("/sd");
    if ( dir == NULL ) {
        pc.printf("failed!\n");
        while(1);
    }
    closedir(dir);
    pc.printf("SD OK!\n");
    
    fp = fopen("/sd/woof.bmp", "r");
    if (fp==NULL) {
        pc.printf("didnt find image\n");
        while (1);
    }

    if (! bmpReadHeader(fp)) { 
        pc.printf("bad bmp\n");
        while(1);
    }

    pc.printf("image size %d, %d\n", bmpWidth, bmpHeight);
    
    bmpdraw(fp, 0, 0);
    wait(1);
    fclose(fp);
    
    fp = fopen("/sd/miniwoof.bmp", "r");
    if (fp==NULL) {
        pc.printf("didnt find image\n");
        while (1);
    }

    if (! bmpReadHeader(fp)) { 
        pc.printf("bad bmp\n");
        while(1);
    }
    pc.printf("image size %d, %d\n", bmpWidth, bmpHeight);

    //LCD_Init();
    tft.initDisplay();
    tft.fillScreen(BLACK);
    wait_ms(1);
    while(1)
    {
        tft.setRotation(0);
        tft.fillScreen(0);
        bmpdraw(fp, 50, 50);
        wait(1);
        
        tft.setRotation(1);
        tft.fillScreen(0);
        bmpdraw(fp, 50, 50);
        wait(1);
        
        tft.setRotation(2);
        tft.fillScreen(0);
        bmpdraw(fp, 50, 50);
        wait(1);
        
        tft.setRotation(3);
        tft.fillScreen(0);
        bmpdraw(fp, 50, 50);
        wait(1);
        tft.setRotation(0);
        rotateText();
        //rotateTest();

        testlinerotate();

        testtext(WHITE);


        testBars();
        testfastlines(CYAN, MAGENTA);
        testtriangles();
        testfilltriangles();
        testfillcircles(50, RED);
        tft.fillScreen(BLACK);
        testdrawcircles(10, YELLOW);
        testdrawrects(GREEN);
        testlines(BLUE);
        testfillrects(RED, WHITE);
        testFillRoundRect();
    
        testdrawrects(GREEN);

        tft.DispColor(RED);     //RED
        wait_us(10);
    
        tft.DispColor(GREEN);   //GREEN
        wait_us(10);
    
        tft.DispColor(BLUE);//BLUE
        wait_us(10);
    
        tft.DispColor(WHITE);   //WHITE        

    }
}