/**
    reference:
    http://www.picfun.com/PIC24F/AP/app24F15.html

    NNUCLEO_F103RB  処理速度が遅い
    NNUCLEO_F446RE  Ok
    ARCH_PRO        Ok
    LPC1768 + Mbed Shield   電源の問題あり
**/

#include "mbed.h"
#include "LCD192GC00.h"
#include "imagedata.h"


#if defined(TARGET_ARCH_PRO)
LCD192GC00 tft(A0, A1, A2, A3, A4, D2, D3, D4, D5, D6, D7, D8, D9);
Serial pc(USBTX, USBRX);
//SDFileSystem sd(D11, D12, D13, D10, "sd"); // mosi miso sclk cs
#elif defined(TARGET_LPC1768)
LCD192GC00 tft(p15, p16, p17, p18, p19, p8, p26, p25, p24, p23, p10, p9, p22);
Serial pc(USBTX, USBRX);
//SDFileSystem sd(p5, p6, p7, p21, "sd"); // mosi miso sclk cs
#elif defined TARGET_NUCLEO_F446RE
/* D0, D1 short SB62,SB63*/
LCD192GC00 tft(A0, A1, A2, A3, A4, D2, D3, D4, D5, D6, D7, D8, D9);
Serial pc(USBTX, USBRX);
//SDFileSystem sd(D11, D12, D13, D10, "sd"); // mosi miso sclk cs

#elif defined TARGET_NUCLEO_F103RB
LCD192GC00 tft(A0, A1, A2, A3, A4, D2, D3, D4, D5, D6, D7, D8, D9);
Serial pc(USBTX, USBRX);
//SDFileSystem sd(D11, D12, D13, D10, "sd"); // mosi miso sclk cs
#endif

int16_t i, j, SW, Flag, Size, XOffset, YOffset;
uint8_t ASCII;
/* Prototyping  */
void D2Graph(short Hight);

int main() {
    tft.lcd_Init();
    tft.lcd_Clear(BLACK);
    SW=6;
    while(1) {
        SW++;
        if(SW==7)
            SW = 0;
        /* スイッチの値により各処理へ分岐 */
        switch(SW){
            /****** ANK文字表示 *********/
            case 0:                                         // 文字表示テスト              
                tft.lcd_Clear(BLACK);                               // クリア
                for(j=0; j<4; j++){                         // ASCII文字全表示　XChar文字/行
                    for(i=0; i<XChar; i++){
                        ASCII = j*XChar+i+0x20;             // XChar文字で繰り返し
                        tft.lcd_Char(i, j, ASCII, WHITE, BLACK);    // 文字表示制御
                    }
                }
                for(j=4; j<8; j++){                         // ASCII文字全表示　XChar文字/行
                    for(i=0; i<XChar; i++){
                        ASCII = j*XChar+i+0x20;             // XChar文字で繰り返し
                        tft.lcd_Char(i, j, ASCII, GREEN, BLACK);    // 文字表示制御
                    }
                }
                for(j=8; j<12; j++){                            // ASCII文字全表示　Xchar文字/行
                    for(i=0; i<XChar; i++){
                        ASCII = j*XChar+i+0x20;             // XChar文字で繰り返し
                        tft.lcd_Char(i, j, ASCII, RED, BLACK);      // 文字表示制御
                    }
                }
                for(j=12; j<YLine; j++){                        // ASCII文字全表示　XChar文字/行
                    for(i=0; i<XChar; i++){
                        ASCII = j*XChar+i+0x20;             // XChar文字で繰り返し
                        tft.lcd_Char(i, j, ASCII, YELLOW, BLACK);   // 文字表示制御
                    }
                }
                wait_ms(3000);                             // 1.5秒待ち
                break;
            /******** 文字列表示テスト　*******/
            case 1:                                         // 文字列の表示テスト
                tft.lcd_Clear(BLACK);
                wait_ms(100);              
                tft.lcd_Str(0, 0, "Hello World!!", RED, BLACK);
                tft.lcd_Str(0, 2, "Graphic LCD Test", GREEN, BLACK);
                tft.lcd_Str(0, 4, "This is Yellow. ", YELLOW, BLACK);
                tft.lcd_Str(0, 6, "This is Cyan.   ", CYAN, BLACK);
                tft.lcd_Str(0, 8, "This is Magenta.", MAGENTA, BLACK);
                tft.lcd_Str(0, 10, "This is Blue and over 30 character case.", BLUE, BLACK); 
                tft.lcd_Str(0, 12, "This is WHITE.", WHITE, BLACK);
                tft.lcd_Str(0, 14, "This is PINK.", PINK, BLACK);
                tft.lcd_Str(0, YLine-1, "This is ORANGE.", ORANGE, BLACK);
                wait_ms(3000);
                break;
            /***** 直線描画テスト（斜め直線) *********/         
            case 2:                                         /* ピクセル表示機能 */                          
                tft.lcd_Clear(BLACK);                               // 全クリア
                for(i=0; i<=ENDPAGE; i++){                      // 斜め直線の表示
                    tft.lcd_Pixel(i*1.33,i,RED);                    // CS1側
                }
                wait_ms(2000);                             // 2秒待ち
                tft.lcd_Clear(WHITE);                               // 全部白
                for(i=0; i<=ENDCOL; i++){                       // 斜め直線表示
                    tft.lcd_Pixel(i*1.33, i, BLUE);
                }
                wait_ms(1500);                             // 1.5秒待ち
                break;
            /************ 直線ボックス表示　**************/
            case 3:                                         // 直線描画テスト
                tft.lcd_Clear(BLACK);
                if(ENDPAGE < ENDCOL){
                    Size = ENDPAGE;
                    XOffset = (ENDCOL - ENDPAGE) / 2;
                    YOffset = 0;
                }
                else{
                    Size = ENDCOL;
                    XOffset = 0;
                    YOffset = (ENDPAGE - ENDCOL) / 2;
                }       
                for(j=0; j<Size/2; j+=4){                       // ボックス表示
                    if(Flag){
                        Flag = 0;
                        // 次第に小さなボックスへ
                        tft.lcd_Line(j+XOffset,j+YOffset, Size-j+XOffset, j+YOffset, RED);
                        tft.lcd_Line(j+XOffset,j+YOffset, j+XOffset, Size-j+YOffset, GREEN);
                        tft.lcd_Line(Size-j+XOffset,Size-j+YOffset, Size-j+XOffset,j+YOffset, RED);
                        tft.lcd_Line(Size-j+XOffset,Size-j+YOffset, j+XOffset,Size-j+YOffset, GREEN);
                    }
                    else{
                        Flag = 1;
                        // 次第に小さなボックスへ
                        tft.lcd_Line(j+XOffset,j+YOffset, Size-j+XOffset, j+YOffset, YELLOW);
                        tft.lcd_Line(j+XOffset,j+YOffset, j+XOffset, Size-j+YOffset, BLUE);
                        tft.lcd_Line(Size-j+XOffset,Size-j+YOffset, Size-j+XOffset,j+YOffset, YELLOW);
                        tft.lcd_Line(Size-j+XOffset,Size-j+YOffset, j+XOffset,Size-j+YOffset, BLUE);
                    }
                }
                wait_ms(3000);
                break;
            /**************** 曲線描画（2次元グラフ表示）****************/
            case 4:
                for(i=0; i<8; i++){                     // 曲線描画
                    tft.lcd_Clear(BLACK);                           
                    tft.lcd_Str(0, 0, "Graphic Display", BLUE, BLACK);
                    D2Graph(20*i);                      //曲面グラフ表示
                    wait_ms(2000);
                }
                break;
            /******* イメージグラフィック表示 ********/
            case 5:                                     // イメージの表示テスト
                tft.lcd_Clear(BLACK);
                tft.lcd_Image(0, Header1, MAGENTA, BLACK);
                tft.lcd_Image(8, Header2, CYAN, BLACK);
                wait_ms(3000);
                break;
            /******** 全画面クリア（各色クリア) ***********/
            case 6:                                     // 全画面クリアのテスト   
                tft.lcd_Clear(WHITE);                           // 各色の表示
                wait_ms(1500);
                tft.lcd_Clear(RED);
                wait_ms(500);
                tft.lcd_Clear(GREEN);
                wait_ms(500);
                tft.lcd_Clear(BLUE);
                wait_ms(500);
                tft.lcd_Clear(CYAN);
                wait_ms(500);
                tft.lcd_Clear(MAGENTA);
                wait_ms(500);
                tft.lcd_Clear(YELLOW);
                wait_ms(500);
                tft.lcd_Clear(BROWN);
                wait_ms(500);
                tft.lcd_Clear(ORANGE);
                wait_ms(500);
                tft.lcd_Clear(PINK);
                wait_ms(500);
                tft.lcd_Clear(BLACK);
                wait_ms(1000);
                break;
            /**** default **********/       
            default: wait_ms(300);
                 break;
        }

    }
}

/*********************************************
*  2次元立体グラフ描画関数
*   z(x,y) = 1/(1+SQRT(x2+y2))*COS(SQRT(x2+y2))
*    (-3*PI< x,y < 3*PIの範囲)
*   zの最大値をPOTで変更する
**********************************************/
/*　グローバル定数 */
#define X0  5
#define Y0  20
#define PI  3.141592654f
#define NODES   38
#define SIDE    6
// 描画関数
void D2Graph(short Hight) {
    short i, j, px, py,x, y, z;
    float zf, xf, yf, sf;
    struct{
        short x;
        short y;
    } edge[NODES], prev;

    tft.lcd_Line(X0, 3, X0, ENDPAGE-12 ,GREEN);             // z axis
    tft.lcd_Line(X0-3, Y0, ENDCOL, Y0, GREEN);              // x axis
    tft.lcd_Line(X0, Y0-2, X0+140, Y0+140, GREEN);          // y axis
    for(j=0; j<NODES; j++) {
        edge[j].x = X0 + j*SIDE/2;
        edge[j].y = Y0 + j*SIDE/2;
    }
    for(i=0; i<NODES; i++) {
        x = i *SIDE;
        xf = (6 * PI / 200) *(float)(x-100);
        prev.y = Y0;
        prev.x = X0 + x;
        for(j=0; j<NODES; j++) {
            y = j * SIDE;
            yf = (6 * PI /200) * (float)(y -100);
            sf = sqrt(xf * xf + yf * yf);
            zf = 1/(1+sf) * cos(sf);
            z = zf * Hight;
            px = X0 + x + y/2;
            py = Y0 + z + y/2;
            tft.lcd_Pixel(px, ENDPAGE-5-py, 1);
            tft.lcd_Line(px, py, prev.x, prev.y, RED);
            tft.lcd_Line(px, py, edge[j].x, edge[j].y, RED);
            prev.x = px;
            prev.y = py;
            edge[j].x = px;
            edge[j].y = py;
        }
    }
}



