/* Example for Spektrum serial receiver driver
 * M. Nentwig, 2011 
 * This program is provided "as is", without any express or implied warranty.  */

#include "mbed.h"
#include "spektRx.h"

/* Serial input
 * Connections:
 * - orange wire to 3.3V regulated out
 * - black wire to GND
 * - grey wire to pin 10 (for example)
 * - see also http://diydrones.ning.com/profiles/blog/show?id=705844%3ABlogPost%3A64228 */
Serial serIn(p9, p10);

PwmOut l1(LED1);
PwmOut l2(LED2);
PwmOut l3(LED3);
PwmOut l4(LED4);

int main(void){
    serIn.baud(115200);

    /* Create parser "object" */
    spektRx_t p;
    spektRx_init(&p);

    while(1) {

        /* Process input data from interface, non-blocking */
        spektRx_runSerial(&p, &serIn);

        /* check if (new) frame has been received */
        if (spektRx_hasValidFrame(&p)){
            
            /* Dump every 10th received frame */
            long fn = spektRx_getFrameNum(&p);
            if (fn % 10 == 0){
                /* Get all channels in bit-accurate form */
                unsigned short* d = spektRx_getChannelData(&p);

                printf("%08li\t", fn);
                printf("ail = %04x\t", (int)d[0]);
                printf("pit = %04x\t", (int)d[1]);
                printf("ele = %04x\t", (int)d[2]);
                printf("rud = %04x\t", (int)d[3]);
                printf("thr = %04x\t", (int)d[4]);
                printf("gear = %04x\t", (int)d[5]);
                printf("aux2 = %04x\t", (int)d[6]);
                printf("\n");
            } /* every 10th frame */ 

            /* Get float values and use to dim the LEDs 
            * The returned range is (-1 .. 1) if the radio has been set up carefully (endpoints / subtrims) */
            /* if this is the case, use f=1 */
            double f = 1.2; /* stretch the range a bit, so that we reach 0/100 % PWM */
            l1 = spektRx_getChannelValue(&p, 0) * 0.5 * f + 0.5;
            l2 = spektRx_getChannelValue(&p, 1) * 0.5 * f + 0.5;
            l3 = spektRx_getChannelValue(&p, 2) * 0.5 * f + 0.5;
            l4 = spektRx_getChannelValue(&p, 3) * 0.5 * f + 0.5;

            /* Finished with the current frame. spectRx_hasValidFrame will return false
             * until the next frame has been received completely. 
             * Notes: 
             * - It is safe to repeatedly read the same frame.
             * - It is safe to read frame n, while frame n-1 has been partly received (driver uses double buffers)
             */
            spektRx_invalidateFrame(&p);
        }
    }
}
