/*
 * Main.cpp
 * Copyright (c) 2020, ZHAW
 * All rights reserved.
 */

#include <mbed.h>
#include <EthernetInterface.h>
#include "IMU.h"
#include "TiltAngle.h"
#include "HTTPServer.h"
#include "HTTPScriptTiltAngle.h"

int main() {
    
    // initialise digital inputs and outputs
    
    printf("Initialise digital inputs and outputs...\r\n");
    
    DigitalIn button(USER_BUTTON);
    
    DigitalOut ledGreen(LED1);
    DigitalOut ledBlue(LED2);
    DigitalOut ledRed(LED3);
    
    // create inertial measurement unit object
    
    printf("Create inertial measurement unit object...\r\n");
    
    SPI spi(PC_12, PC_11, PC_10);
    DigitalOut csAG(PC_8);
    DigitalOut csM(PC_9);
    
    IMU imu(spi, csAG, csM);
    
    TiltAngle tiltAngle(imu);
    
    // create ethernet interface and webserver
    
    printf("Create ethernet interface and webserver (please wait!)...\r\n");
    
    EthernetInterface* ethernet = new EthernetInterface();
    ethernet->set_network("192.168.201.44", "255.255.255.0", "192.168.201.1"); // configure IP address, netmask and gateway address
    ethernet->connect();
    
    HTTPServer* httpServer = new HTTPServer(*ethernet);
    httpServer->add("tiltAngle", new HTTPScriptTiltAngle(tiltAngle));
    
    // enter main loop
    
    printf("Enter main loop...\r\n");
    
    while (true) {
        
        // set LEDs on microcontroller
        
        ledGreen = 1;
        ledBlue = 0;
        ledRed = 0;
        
        ThisThread::sleep_for(100);
        
        ledGreen = 0;
        ledBlue = 1;
        ledRed = 0;
        
        ThisThread::sleep_for(100);
        
        ledGreen = 0;
        ledBlue = 0;
        ledRed = 1;
        
        ThisThread::sleep_for(100);
        
        ledGreen = 0;
        ledBlue = 0;
        ledRed = 0;
        
        // print data into terminal
        
        printf("TiltAngle: %.3f\r\n", tiltAngle.readTiltAngleK());
    }
}

