/*
 * HTTPScriptTiltAngle.h
 * Copyright (c) 2020, ZHAW
 * All rights reserved.
 */

#ifndef HTTP_SCRIPT_TILT_ANGLE_H_
#define HTTP_SCRIPT_TILT_ANGLE_H_

#include <string>
#include <vector>
#include "HTTPScript.h"
#include "TiltAngle.h"

/**
 * This is a specific http script to read tilt angles from a TiltAngle object.
 * @see HTTPServer
 */
class HTTPScriptTiltAngle : public HTTPScript {
    
    public:
        
                            HTTPScriptTiltAngle(TiltAngle& tiltAngle);
        virtual             ~HTTPScriptTiltAngle();
        virtual std::string call(std::vector<std::string> names, std::vector<std::string> values);
        
    private:
        
        TiltAngle&          tiltAngle;
};

#endif /* HTTP_SCRIPT_TILT_ANGLE_H_ */

