/*
 * HTTPScriptTiltAngle.cpp
 * Copyright (c) 2020, ZHAW
 * All rights reserved.
 */

#include "HTTPScriptTiltAngle.h"

using namespace std;

inline string float2String(float f) {
    
    char buffer[32];
    sprintf(buffer, "%.3f", f);
    
    return string(buffer);
}

/**
 * Create and initialize this http script.
 * @param tiltAngle a reference to the tiltAngle objetct to read data from.
 */
HTTPScriptTiltAngle::HTTPScriptTiltAngle(TiltAngle& tiltAngle) : tiltAngle(tiltAngle) {}

HTTPScriptTiltAngle::~HTTPScriptTiltAngle() {}

/**
 * This method gets called by the http server, when an object of this class is
 * registered with the server, and the corresponding script is called
 * by an http client.
 */
string HTTPScriptTiltAngle::call(vector<string> names, vector<string> values) {
    
    string response;
    
    response += "  <tiltAngle>\r\n";
    response += "    <a><float>"+float2String(tiltAngle.readTiltAngleA())+"</float></a>\r\n";
    response += "    <g><float>"+float2String(tiltAngle.readTiltAngleG())+"</float></g>\r\n";
    response += "    <k><float>"+float2String(tiltAngle.readTiltAngleK())+"</float></k>\r\n";
    response += "    <c><float>"+float2String(tiltAngle.readTiltAngleC())+"</float></c>\r\n";
    response += "  </tiltAngle>\r\n";
    
    return response;
}

