/*
 * Main.cpp
 * Copyright (c) 2020, ZHAW
 * All rights reserved.
 */

#include <mbed.h>
#include <EthernetInterface.h>
#include "LIDAR.h"
#include "HTTPServer.h"
#include "HTTPScriptLIDAR.h"

int main() {
    
    // initialise digital inputs and outputs
    
    printf("Initialise digital inputs and outputs...\r\n");
    
    DigitalIn button(USER_BUTTON);
    
    DigitalOut ledGreen(LED1);
    DigitalOut ledBlue(LED2);
    DigitalOut ledRed(LED3);
    
    // create LIDAR device driver
    
    printf("Create LIDAR device driver...\r\n");
    
    PwmOut pwm(PE_9);
    pwm.period(0.00005f);
    pwm.write(0.5f);
    
    ThisThread::sleep_for(500);
    
    RawSerial serial(PG_14, PG_9);
    LIDAR lidar(serial);
    
    // create ethernet interface and webserver
    
    printf("Create ethernet interface and webserver (please wait!)...\r\n");
    
    EthernetInterface* ethernet = new EthernetInterface();
    ethernet->set_network("192.168.201.44", "255.255.255.0", "169.168.201.1"); // configure IP address, netmask and gateway address
    ethernet->connect();
    
    HTTPServer* httpServer = new HTTPServer(*ethernet);
    httpServer->add("lidar", new HTTPScriptLIDAR(lidar));
    
    // enter main loop
    
    printf("Enter main loop...\r\n");
    
    while (true) {
        Timer timer;
        timer.start();
        lidar.getBeacons();
        int duration = timer.read_us();
        printf("Zeit für getBeacons: %d \r\n",duration);
        timer.reset();
        ThisThread::sleep_for(100);
        // set LEDs on microcontroller
        
        ledGreen = 1;
        ledBlue = 0;
        ledRed = 0;
        
        ThisThread::sleep_for(100);
        
        ledGreen = 0;
        ledBlue = 1;
        ledRed = 0;
        
        ThisThread::sleep_for(100);
        
        ledGreen = 0;
        ledBlue = 0;
        ledRed = 1;
        
        ThisThread::sleep_for(100);
    }
}

