/*
 * Main.cpp
 * Copyright (c) 2020, ZHAW
 * All rights reserved.
 */

#include <mbed.h>
#include <EthernetInterface.h>
#include "IMU.h"
#include "HTTPServer.h"
#include "HTTPScriptIMU.h"

int main() {
    
    // initialise digital inputs and outputs
    
    printf("Initialise digital inputs and outputs...\r\n");
    
    DigitalIn button(USER_BUTTON);
    
    DigitalOut ledGreen(LED1);
    DigitalOut ledBlue(LED2);
    DigitalOut ledRed(LED3);
    
    // create inertial measurement unit object
    
    printf("Create inertial measurement unit object...\r\n");
    
    SPI spi(PC_12, PC_11, PC_10);
    DigitalOut csAG(PC_8);
    DigitalOut csM(PC_9);
    
    IMU imu(spi, csAG, csM);
    
    // create ethernet interface and webserver
    
    printf("Create ethernet interface and webserver (please wait!)...\r\n");
    
    EthernetInterface* ethernet = new EthernetInterface();
    ethernet->set_network("169.254.20.110", "255.255.0.0", "0.0.0.0"); // configure IP address, netmask and gateway address
    ethernet->connect();
    
    HTTPServer* httpServer = new HTTPServer(*ethernet);
    httpServer->add("imu", new HTTPScriptIMU(imu));
    
    // enter main loop
    
    printf("Enter main loop...\r\n");
    
    while (true) {
        
        // set LEDs on microcontroller
        
        ledGreen = 1;
        ledBlue = 0;
        ledRed = 0;
        
        ThisThread::sleep_for(100);
        
        ledGreen = 0;
        ledBlue = 1;
        ledRed = 0;
        
        ThisThread::sleep_for(100);
        
        ledGreen = 0;
        ledBlue = 0;
        ledRed = 1;
        
        // print sensor data into terminal
        
        printf("Gyro: %.3f / %.3f / %.3f\r\n", imu.readGyroX(), imu.readGyroY(), imu.readGyroZ());
        printf("Acceleration: %.3f / %.3f / %.3f\r\n", imu.readAccelerationX(), imu.readAccelerationY(), imu.readAccelerationZ());
        printf("Magnetometer: %.3f / %.3f / %.3f\r\n", imu.readMagnetometerX(), imu.readMagnetometerY(), imu.readMagnetometerZ());
        printf("Orientation: %.3f\r\n", imu.readHeading());
    }
}

