/* Created by Mark Oehlberg 8/21/14

Automatic keyboard app

You are viewing the code for the future of keyboards.  You might as well
smash your current keyboard, because once you use your KL25Z as a keyboard
you will never look back.

The Keyboard uses the touch slider and splits it in to two buttons, a left and a right button.
The left Button types Pirates! and the right button types ROBOTS!

The two USB ports on the board are labeled SDA and USB.  Use the port called USB to type.
The LED will light on when pressed as well.

*/

#include "mbed.h"
#include "tsi_sensor.h"
#include "USBKeyboard.h"

/* A couple of boards have different pins connected */
#if defined (TARGET_KL25Z) || defined (TARGET_KL46Z)
  #define ELEC0 9
  #define ELEC1 10
#elif defined (TARGET_KL05Z)
  #define ELEC0 9
  #define ELEC1 8
#else
  #error TARGET NOT DEFINED
#endif

Serial pc(USBTX, USBRX);//begins a serial console named pc
USBKeyboard keyboard;


int main(void) {
    bool justpressed = false;//variable used to 
    float lastpressed = 0.0;
    pc.baud(115200);//I apparently have to do this in the main loop
    DigitalOut led(LED2);//also called LED_GREEN
    TSIAnalogSlider tsi(ELEC0, ELEC1, 40);
    float i=0.0;
    while (true) {
        i=1.0 - tsi.readPercentage();//i=1.0000 when not pressed and will be between 0 and 1 when touched
        led = (i == 1.0) ? 1 : 0;//turn the light on if the slider is pressed.  Outputting Zero on this pin connects the cathode to ground.  The annode is connected to 3.3V
        if (justpressed && (abs(lastpressed-i)>0.1)){
            justpressed=false;
        }
        if ( 0.5 < i && i < 1.0 && not justpressed ){          
            keyboard.printf("Pirates!\r\n");
            lastpressed = i;
            justpressed = true;
            pc.printf(" Pirates - Trigger number=%f\n\r",i);
        }else if (0.0 < i && i <= 0.5 && not justpressed ){          
            keyboard.printf("ROBOTS!\r\n");
            lastpressed = i;
            justpressed = true;
            pc.printf(" ROBOTS!- Trigger number=%f\n\r",i);
        }
        //pc.printf("Reading:%f\tlastpressed:%f Justpressed:%d\n\r", i,lastpressed, justpressed);//debug code
    }
}
