#include "mbed.h"
#include "MMA8451Q.h"//This is the onboard accelerometer

#if   defined (TARGET_KL25Z) || defined (TARGET_KL46Z)//This is the board I have and I guess they changed some pins around
  PinName const SDA = PTE25;
  PinName const SCL = PTE24;
#elif defined (TARGET_KL05Z)
  PinName const SDA = PTB4;
  PinName const SCL = PTB3;
#else
  #error TARGET NOT DEFINED
#endif

#define MMA8451_I2C_ADDRESS (0x1d<<1)

//Serial pc(USBTX, USBRX);//The accelerometer didn't have to do this...I guess this is how you could change baud rates
//int baudrate = 115200;

int main(void) {
    MMA8451Q acc(SDA, SCL, MMA8451_I2C_ADDRESS);
    //pc.baud(baudrate);
    PwmOut rled(LED1);//pwms are 0-1 with 0 being off and 1 on
    PwmOut gled(LED2);
    PwmOut bled(LED3);
    
    printf("MMA8451 ID: %d\n", acc.getWhoAmI());
    float x,y,z,accx, accy, accz;

    while (true) {
        
        accx = abs(acc.getAccX());
        accy = abs(acc.getAccY());
        accz = abs(acc.getAccZ());

        x = rled = 1.0 - accx;
        y = gled = 1.0 - accy;
        z = bled = 1.0 - accz;
        
        wait(0.5);//I don't think 12c can poll as fast as the processor can go.  The delay is needed for this
        printf("Red: %1.5f, Green: %1.5f, Blue: %1.5f\t Acceleration X: %1.10f Y: %fZ: %1.5f\n\r", x, y, z,accx,accy,accz);//so \n goes down one line, but does not get me to the beggining of a line.  \r gets to the beginning of the line so the formatting is right
    }
}
