#include "mbed.h"
#include "N5110.h"
#include "beep.h"
#include "BMP180.h"

N5110 lcd(p7,p8,p9,p10,p11,p13,p26);
Beep buzzer(p21);
BusOut leds(LED4,LED3,LED2,LED1);
BMP180 bmp180(p28,p27);
InterruptIn  button(p15);
DigitalOut led(p24);

#define up 1
#define down 0

int state = up;

int buttonFlag = 0;

void buttonPressed()
{
    state = ! state;     
}




int main()
{   
    lcd.init();
    bmp180.init();
    
    //startup picture
    //the project name is Weather Station, print it on screen
    lcd.printString("Weather",1,1);
    lcd.printString("Station",1,2);
    
    wait(2.0); //keep the startup picture for 2 seconds
    lcd.clear(); //clear the screen
    buzzer.beep(2000,1.0); //the buzzer beeps at 2000Hz for 1 second
    Measurement measurement; //start to measure temperature and atmosphere pressure
    button.rise(&buttonPressed); //check the button rised
    
    
    while(1)
    {
            measurement = bmp180.readValues(); 
            char celsius[14];//create a bufffer named celsius
            int length = sprintf(celsius,"T = %.2f C",measurement.temperature); //The value measured by the sensor is put into the variable "celsius". And it is displayed on screen.
             
            char pressure[14];//create a bufffer named pressure
            
            //The value measured by the sensor is put into the variable "pressure". And it is displayed on screen.
            length = sprintf(pressure,"P = %.2f hPa",measurement.pressure);

            float f = (measurement.temperature + 32)*1.8; //the formula to change unit between Celsius and Fahrenheit.    
            char fahrenheit[14];
                
            //display values on screen
            length = sprintf(fahrenheit,"T = %.2f F",f);

            //All words will stay on screen for 1 second in case that the numbers changes too fast to read. 
            wait(1.0);
            lcd.clear();
 
 
 
            switch(state)
            {
                case up:
                    state = 1;
                    lcd.printString("Celsius",0,0); //Celsius is shown in the first line on the screen. The default unit of temperature is Celsius. 
                      
                    //Atmosphere Pressure is shown in the 3rd and 4th line on screen.
                    lcd.printString("Atmosphere",0,3);
                    lcd.printString("Pressure",0,4);
                    
                    //display the values of temperature and air pressure
                    lcd.printString(celsius,0,1);
                    lcd.printString(pressure,0,5);    
                    break;
                    
                case down:     
                    state = 0;
                    lcd.printString("Fahrenheit",0,0); //Fahrenheit is shown in the first line on the screen. The default unit of temperature is Fahrenheit.
                    
                     //Atmosphere Pressure is shown in the 3rd and 4th line on screen.
                    lcd.printString("Atmosphere",0,3);
                    lcd.printString("Pressure",0,4);
                    
                    //display the values of temperature and air pressure
                    lcd.printString(fahrenheit,0,1);
                    lcd.printString(pressure,0,5);                    
                default:
                    break;   
            }
            
            
             
            //set a range of suitable temperature
            //if temperature is greater than 28 degrees,the buzzer will beep at 3000Hz for 0.5 seconds and the LED will work.
            if (measurement.temperature >= 28.00)
            {
            buzzer.beep(3000,0.5); //the buzzer beeps at 3000Hz for 0.5 seconds
            led = 1; //the LED works
            }
            
            //if temperature is less than 25 degrees, the buzzer will beep at 2000Hz for 1 second and LED will not work.
            else if (measurement.temperature <= 25.00)
            {   
            buzzer.beep(2000,1.0); //the buzzer beeps at 2000Hz for 1 second
            led = 0; //LED does not work
            }
            
            //if temperature is between 25 to 28 degrees, neither of the buzzer and the LED works.
            else 
            {   
            buzzer.nobeep(); //buzzer no beeping 
            led =0; //LED off
            }                  
    }
                         
}
    