#ifndef SHT21_HPP_INCLUDED
#define  SHT21_HPP_INCLUDED

#include "mbed.h"

class SHT21 {
public:
    SHT21(PinName sda, PinName scl, char addr = (0x40 << 1));
    SHT21(I2C &i2c,  char addr = (0x40 << 1));
    
    float temperature();
    float humidity();
    
    void reset();
    void serialNumber(uint8_t *serialNumber);
    
    ~SHT21();
private:
    enum commands {
        TRIGGER_T_MEASUREMENT_HM    = 0xE3,
        TRIGGER_RH_MEASUREMENT_HM   = 0xE5,
        TRIGGER_T_MEASUREMENT_NHM   = 0xF3,
        TRIGGER_RH_MEASUREMENT_NHM  = 0xF5,
        USER_REGISTER_W             = 0xE6,
        USER_REGISTER_R             = 0xE7,
        SOFT_RESET                  = 0xFE
    };

    static const uint16_t POLYNOMIAL;

    char addr_;
    I2C *pi2c_;
    I2C &i2c_;
    
    uint16_t readRaw(uint8_t cmd);
    static bool crcChecksum(const uint8_t *data, uint8_t sz, uint8_t checksum);
};

#endif // SHT21_HPP_INCLUDED
