#ifndef _LT_I2C_COMPAT_H_INCLUDED
#define _LT_I2C_COMPAT_H_INCLUDED

// I used lt_i2c_ in order to avoid name clashes

#include <stdint.h>

#define LT_I2C_READ_BIT    0x01
#define LT_I2C_WRITE_BIT   0x00
#define LT_I2C_WITH_NACK       1
#define LT_I2C_WITH_ACK        0       //!< in mbed 1 if byte to be acknowledged, be careful

#define LT_I2C_INIT_FINE           0x00
#define LT_I2C_INIT_QUIT_FIRST     0x01

#define LT_I2C_SUCCESS             0x00
#define LT_I2C_FAILURE             0x01

int lt_i2c_init(int sda, int scl);
int lt_i2c_quit();

int lt_i2c_init_attach(void *p_lt_i2c_object);

void *lt_i2c_get_lt_i2c_object();

int lt_i2c_start();
int lt_i2c_stop();

uint8_t lt_i2c_write(uint8_t data);
uint8_t lt_i2c_read(int8_t ack);

int8_t lt_i2c_write_byte_data(
    uint8_t address,
    uint8_t command,
    uint8_t value);

int8_t lt_i2c_write_word_data(
    uint8_t address,
    uint8_t command,
    uint16_t value);

uint8_t lt_i2c_write_block_data(
    uint8_t address,
    uint8_t command,
    uint8_t length,
    uint8_t *values);

uint8_t lt_i2c_read_byte_data(
    uint8_t address,
    uint8_t command,
    uint8_t *value);

uint8_t lt_i2c_read_word_data(
    uint8_t address,
    uint8_t command,
    uint16_t *value);

uint8_t lt_i2c_read_block_data(
    uint8_t address,
    uint8_t command,
    uint8_t length,
    uint8_t *values);

#endif // _LT_I2C_COMPAT_H_INCLUDED
