//----------------------------------------------------------------------------------------
// Project:   MIDIExpressionPedal
// Function:  use the mbed board to convert a potentiometr into a MIDI expression pedal
// Author:    Dr.-Ing. O.C. Zeides, using some code from the Cookbook
// Version:  26.11.2009
//---------------------------------------------------------------------------------------- 

#include "mbed.h"
#include "MIDI.h"

MIDI midi(p13, p14);           // our MIDI communication channel
DigitalOut myled(LED1);        // status LED, should flash if we update the controller
AnalogIn potentiometer(p20);   // here is where we connect our potentiometer

float last_pot = 0.0;          // memorize the old potentiometer value
float actual_pot;              // actual poentiometer value
float hysterese = 0.1;         // only send new message if we have moved the potentiometer that far
float fvalue = 0.0;

int controllerNo = 1;          // MIDI controller No
int channelNo = 1;             // MIDI channel No.
int value = 0;                 // MIDI value for controller

// send the new value to the controller
void updateMIDIController(void)
{
   myled = 1;
   fvalue = actual_pot * 127.0;
   value = (int) fvalue;
   midi.controller(controllerNo,value,channelNo);
   wait(0.5);
   myled = 0;
} // updateMIDIController()

int main() {
   
   while(1) { // do forever
// get new pot value
      actual_pot = potentiometer;
// compare with last pot value  
      if(actual_pot > (last_pot + hysterese))
         updateMIDIController();
      if(actual_pot < (last_pot - hysterese))
         updateMIDIController();
    
      last_pot = actual_pot;   
  
   } // while
   
} // main()



