
#include "wifi_demo.h"
#include "common_config.h"
// Wifi-demo

RawSerial *device; // tx, rx
extern EventQueue eventQueue(/* event count */ 20 * EVENTS_EVENT_SIZE);
int chunkNum;
void dump_response(HttpResponse* res) {
    device->printf("Status: %d - %s\n", res->get_status_code(), res->get_status_message().c_str());

    device->printf("Headers:\n");
    for (size_t ix = 0; ix < res->get_headers_length(); ix++) {
        device->printf("\t%s: %s\n", res->get_headers_fields()[ix]->c_str(), res->get_headers_values()[ix]->c_str());
    }
    char * body = (char *) res->get_body();
    device->printf("\nBody (%lu bytes):\n\n%s\n", res->get_body_length(), res->get_body_as_string().c_str());
        for (size_t ix = 0; ix < res->get_body_length(); ix++) {
        device->printf("%02X: ", body[ix]);
        if((ix % 32) == 0 and ix)
        device->printf("\n");
    }

}

void completed(){
    }
void dump_chunked_response(const char *at, uint32_t length) {
    device->printf("\n Chunked response: Chunk %d : Total Bytes = %d\n", chunkNum , length);
    //device->printf("\n Try Print Header as string:\n\n ");
    //device->printf("recv %d [%.*s]\n", length, strstr((char *)at, "\r\n")-(char *)at, (char *)at);
    //if(false)
    if(chunkNum < 2)
    for(int i=0; i < length; i++){
        
        while(device->writeable())
        {
            device->putc((uint8_t)at[i]);
        }
        //int resp = write( (const uint8_t *)at, (int) length, &completed, SERIAL_EVENT_TX_COMPLETE);
    }
    if(false)
    for (size_t ix = 0; ix < length; ix++) {
        device->printf("%02X: ", at[ix]);
        if((ix % 32) == 0 and ix)
        device->printf("\n");
    }
    device->printf("\n\n");
    chunkNum++;
    //device->printf("\nBody (%lu bytes):\n\n%s\n", res->get_body_length(), res->get_body_as_string().c_str());
}


int wifi_demo_func(NetworkInterface* network){
    device = new RawSerial(USBTX, USBRX, DEFAULT_BAUD_RATE);
    if (!network) {
        device->printf("Cannot connect to the network, see serial output\n");
        return 1;
    }
    wait(1); // wait for 1 sec 

    mbed_trace_init();
#ifdef RUN_ALL    
    wait(1); // wait for 1 sec 

    // GET request to os.mbed.com
    {
        chunkNum = 0;
        device->printf("\n----- HTTPS GET request -----\n");

        HttpsRequest* get_req = new HttpsRequest(network, SSL_CA_PEM, HTTP_GET, "https://os.mbed.com/media/uploads/mbed_official/hello.txt", &dump_chunked_response);

        HttpResponse* get_res = get_req->send();
        if (!get_res) {
            device->printf("HttpRequest failed (error code %d)\n", get_req->get_error());
            return 1;
        }
        device->printf("\n----- HTTPS GET response -----\n");
        dump_response(get_res);
        delete get_req;
    }
    
    wait(1); // wait for 1 sec 
    
     // Do a GET request to httpbin.org
    {
        chunkNum = 0;
        device->printf("\n----- HTTP GET request to httpbin.org  -----\n");

        // By default the body is automatically parsed and stored in a buffer, this is memory heavy.
        // To receive chunked response, pass in a callback as last parameter to the constructor.
        HttpRequest* get_req = new HttpRequest(network, HTTP_GET, "http://httpbin.org/status/418");

        HttpResponse* get_res = get_req->send();
        if (!get_res) {
            device->printf("HttpRequest failed (error code %d)\n", get_req->get_error());
            return 1;
        }

        device->printf("\n----- HTTP GET response from httpbin.org -----\n");
        dump_response(get_res);

        delete get_req;
    }

    wait(1); // wait for 1 sec 
    
    
    // Do a GET request to ovh.net
    if(false)
    {
       chunkNum = 0;
       device->printf("\n----- HTTP GET request to ovh.net  (LARGE FILE) http://www.ovh.net/files/1Mio.dat -----\n");
        Timer t;
        // By default the body is automatically parsed and stored in a buffer, this is memory heavy.
        // To receive chunked response, pass in a callback as last parameter to the constructor.
        t.start();
        HttpRequest* get_req = new HttpRequest(network, HTTP_GET, "http://www.ovh.net/files/1Mio.dat", &dump_chunked_response);

        HttpResponse* get_res = get_req->send();
        if (!get_res) {
            device->printf("HttpRequest failed (error code %d)\n", get_req->get_error());
            return 1;
        }

        device->printf("\n----- HTTP GET response from ovh.net -----\n");
        dump_response(get_res);
        t.stop();
        device->printf("The time taken was %f seconds\n", t.read());


        delete get_req;
    }
     wait(1); // wait for 1 sec 
   
    {
        device->printf("\n----- HTTPS GET request (small file!) -----\n");

        HttpsRequest* get_req = new HttpsRequest(network, SSL_CA_PEM, HTTP_GET, "https://os.mbed.com/media/uploads/mbed_official/hello.txt");

        HttpResponse* get_res = get_req->send();
        if (!get_res) {
            device->printf("HttpRequest failed (error code %d)\n", get_req->get_error());
            return 1;
        }
        /*
        while (0 < (response = socket.recv(p, remaining))) {
            p += response;
            rcount += response;
            remaining -= response;
        }
        */
        device->printf("\n----- HTTPS GET response -----\n");
        dump_response(get_res);



        delete get_req;
    }
    wait(1); // wait for 1 sec 

    // POST request to httpbin.org
    {
        device->printf("\n----- HTTPS POST request -----\n");

        HttpsRequest* post_req = new HttpsRequest(network, SSL_CA_PEM, HTTP_POST, "https://httpbin.org/post");
        post_req->set_header("Content-Type", "application/json");

        const char body[] = "{\"hello\":\"world\"}";

        HttpResponse* post_res = post_req->send(body, strlen(body));
        if (!post_res) {
            device->printf("HttpRequest failed (error code %d)\n", post_req->get_error());
            return 1;
        }

        device->printf("\n----- HTTPS POST response -----\n");
        dump_response(post_res);

        delete post_req;
    }

    wait(1); // wait for 1 sec 

    // POST request to ws.dnanudge.io:80
    {
        device->printf("\n----- HTTP POST request (http://ws.dnanudge.io/nudgebox/v1) -----\n");

        HttpRequest* post_req = new HttpRequest(network, HTTP_POST, "http://ws.dnanudge.io/nudgebox/v1");
        post_req->set_header("Host", "ws.dnanudge.io");
        post_req->set_header("Accept", "*/*");
        post_req->set_header("Content-Type", "application/octet-stream");
        post_req->set_header("Content-Length", "20");
                               // 00    08    6a    48    f8    2d    8e    82    01    68
        const uint8_t body[] = {0x00, 0x08, 0x6a, 0x48, 0xf8, 0x2d, 0x8e, 0x82, 0x01, 0x68, 
                               // 65    6c    6c    6f    00    00    67    c3    19    f8
                                0x65, 0x6c, 0x6c, 0x6f, 0x00, 0x00, 0x67, 0xc3, 0x19, 0xf8};

        HttpResponse* post_res = post_req->send(body, 20);
        if (!post_res) {
            device->printf("HttpRequest failed (error code %d)\n", post_req->get_error());
            return 1;
        }

        device->printf("\n----- HTTPS POST response -----\n");
        dump_response(post_res);

        delete post_req;
    }

    wait(1); // wait for 1 sec 
    // POST request to httpbin.org
    if(false)
    {
        device->printf("\n----- HTTPS POST request to AWS -----\n");

        HttpsRequest* post_req = new HttpsRequest(network, SSL_CA_PEM, HTTP_POST, "https://q6bc0dxw7f.execute-api.eu-west-2.amazonaws.com/test/samples/v1");
        post_req->set_header("Content-Type", "application/json");

        const char body[] = 
                            "{"
                            "\"firstName\": \"Maria\", "
                            "\"lastName\": \"Huntera\", "
                            "\"dob\": \"1970-12-03\", "
                            "\"mobile\": \"07841887580\", "
                            "\"cartridgeId\": \"DN00000000RMPOE\", "
                            "\"labSampleId\": \"DYYAK\""
                            "}";
        HttpResponse* post_res = post_req->send(body, strlen(body));
        if (!post_res) {
            device->printf("HttpRequest failed (error code %d)\n", post_req->get_error());
            return 1;
        }

        device->printf("\n----- HTTPS POST response from AWS -----\n");
        dump_response(post_res);

        delete post_req;
    }
    
#endif
    
        // POST request to dev2.dnanudge.io
    if(true)
    {
        device->printf("\n----- HTTPS POST request to dev2.dnanudge.io -----\n");
        TLSSocket*            socket;
        socket = new TLSSocket();
        char hostName[] = "dev2.dnanudge.io";
        nsapi_error_t r;
        // make sure to check the return values for the calls below (should return NSAPI_ERROR_OK)
        r = socket->open(network);
        if(r != NSAPI_ERROR_OK)
        { 
            printf("TLS open failed!!\n");
            return 0;
        }
        printf("TLS open passed!!\n");
        r = socket->set_root_ca_cert(SSL_CA_PEM);
        if(r != NSAPI_ERROR_OK)
        { 
            printf("TLS set_root_ca_cert failed!!\n");
            return 0;
        }
        printf("TLS set_root_ca_cert passed!!\n");
        r = socket->connect(hostName, 443);
        if(r != NSAPI_ERROR_OK)
        { 
            printf("TLS connect failed for hostname %s!!\n", hostName);
            return 0;
        }
        printf("TLS connection successful for https site :  %s\n", hostName);
        //HttpsRequest* post_req = new HttpsRequest(network, SSL_CA_PEM, HTTP_POST, "https://dev2.dnanudge.io/nudgebox/v1");
        HttpsRequest* post_req = new HttpsRequest(socket, HTTP_POST, "https://dev2.dnanudge.io/nudgebox/v1");
        //post_req->set_header("Content-Type", "application/json");
        post_req->set_header("Accept", "*/*");
        post_req->set_header("Content-Type", "application/octet-stream");
        post_req->set_header("Content-Length", "20");

        const char body[] = {0x00, 0x08, 0x6a, 0x48, 0xf8, 0x2d, 0x8e, 
                             0x82, 0x01, 0x68, 0x65, 0x6c, 0x6c, 0x6f, 0x00, 0x00, 0x67, 
                             0xc3, 0x19, 0xf8};
        HttpResponse* post_res = post_req->send(body, 20);
        if (!post_res) {
            device->printf("HttpRequest failed (error code %d)\n", post_req->get_error());
            return 1;
        }

        device->printf("\n----- HTTPS POST response from dev2.dnanudge.io -----\n");
        dump_response(post_res);

        delete post_req;
    }

     wait(1); // wait for 1 sec 
     delete device;
     return 0;
}
