#ifndef _MBED_HTTP_EXAMPLE_H_
#define _MBED_HTTP_EXAMPLE_H_

#include "mbed.h"
#ifdef TARGET_SIMULATOR
#include "EthernetInterface.h"
#endif


const char * sec2str(nsapi_security_t sec)
{
    switch (sec) {
        case NSAPI_SECURITY_NONE:
            return "None";
        case NSAPI_SECURITY_WEP:
            return "WEP";
        case NSAPI_SECURITY_WPA:
            return "WPA";
        case NSAPI_SECURITY_WPA2:
            return "WPA2";
        case NSAPI_SECURITY_WPA_WPA2:
            return "WPA/WPA2";
        case NSAPI_SECURITY_UNKNOWN:
        default:
            return "Unknown";
    }
}
#define MAX_CHANNEL_NUM 4
const int channel_list [] = {1,11, 36, 44};
int getAPcount(WiFiInterface *wifi)
{
    int count = 0;
    for(uint8_t idx=0; idx< MAX_CHANNEL_NUM;idx++){
        printf("\n Scanning channel %d - APs so far = %d\n", channel_list[idx], count);
        wifi->set_channel(channel_list[idx]);
        count += wifi->scan(NULL,0);
        wait_ms(150); // wait for 150 ms between scans
    }
    printf("\n Total APs found = %d\n", count);
    return count;
}

#define MAX_APs_PER_CHAN 3
int getAPdetails(WiFiAccessPoint *ap, WiFiInterface *wifi, int apCount)
{
     int count =0;
     for(uint8_t idx=0; idx< MAX_CHANNEL_NUM;idx++){
        printf("\n Scanning channel %d - APs so far = %d  apCount =%d\n", channel_list[idx], count, apCount);
        wifi->set_channel(channel_list[idx]);
        count += wifi->scan(&ap[count],(apCount - count) % MAX_APs_PER_CHAN);
        wait_ms(150); // wait for 150 ms between scans
        if(count >= apCount) break;
    }
    wifi->set_channel(0);
    printf("\n Total APs found = %d\n", count);
    return count;
}

int scan_demo2(WiFiInterface *wifi)
{
    WiFiAccessPoint *ap;

    printf("Scan:\n");

    //int count = wifi->scan(NULL,0);
    int count;
    count = getAPcount(wifi);
    if (count <= 0) {
        printf("scan() failed with return value: %d\n", count);
        return 0;
    }

    /* Limit number of network arbitrary to 15 */
    count = count < 15 ? count : 15;

    ap = new WiFiAccessPoint[count];
    //count = wifi->scan(ap, count);
    count = getAPdetails(ap, wifi, count);

    if (count <= 0) {
        printf("scan() failed with return value: %d\n", count);
        return 0;
    }

    for (int i = 0; i < count; i++) {
        printf("Network: %s secured: %s BSSID: %hhX:%hhX:%hhX:%hhx:%hhx:%hhx RSSI: %hhd Ch: %hhd\n", ap[i].get_ssid(),
               sec2str(ap[i].get_security()), ap[i].get_bssid()[0], ap[i].get_bssid()[1], ap[i].get_bssid()[2],
               ap[i].get_bssid()[3], ap[i].get_bssid()[4], ap[i].get_bssid()[5], ap[i].get_rssi(), ap[i].get_channel());
    }
    printf("%d networks available.\n", count);

    delete[] ap;
    return count;
}


int scan_demo(WiFiInterface *wifi)
{
    WiFiAccessPoint *ap;

    printf("Scan:\n");

    int count = wifi->scan(NULL,0);

    if (count <= 0) {
        printf("scan() failed with return value: %d\n", count);
        return 0;
    }

    /* Limit number of network arbitrary to 15 */
    count = count < 15 ? count : 15;

    ap = new WiFiAccessPoint[count];
    count = wifi->scan(ap, count);

    if (count <= 0) {
        printf("scan() failed with return value: %d\n", count);
        return 0;
    }

    for (int i = 0; i < count; i++) {
        printf("Network: %s secured: %s BSSID: %hhX:%hhX:%hhX:%hhx:%hhx:%hhx RSSI: %hhd Ch: %hhd\n", ap[i].get_ssid(),
               sec2str(ap[i].get_security()), ap[i].get_bssid()[0], ap[i].get_bssid()[1], ap[i].get_bssid()[2],
               ap[i].get_bssid()[3], ap[i].get_bssid()[4], ap[i].get_bssid()[5], ap[i].get_rssi(), ap[i].get_channel());
    }
    printf("%d networks available.\n", count);

    delete[] ap;
    return count;
}



/**
 * Connect to the network using the default networking interface,
 * you can also swap this out with a driver for a different networking interface
 * if you use WiFi: see mbed_app.json for the credentials
 */
NetworkInterface *connect_to_default_network_interface() {
    printf("[NWKH] Connecting to network...\n");

#ifdef TARGET_SIMULATOR
    NetworkInterface* network = new EthernetInterface();
#else
    //NetworkInterface* network = NetworkInterface::get_default_instance();
    WiFiInterface *network = WiFiInterface::get_default_instance();
    if (!network) {
        printf("ERROR: No WiFiInterface found.\n");
        return NULL;
    }
    nsapi_error_t error;
    
    error = network->set_blocking(false);
    printf("Wifi Interface set to Non-Blocking .\n");
    printf("Waiting for 5 seconds before starting scan...\n");
    for(int i=0;i<5;i++){
        printf("%d", i);
        wait(1);
    }
    int count;
    count = scan_demo(network);
    //count = scan_demo2(network);
    if (count == 0) {
        printf("No WIFI APNs found - can't continue further.\n");
        return NULL;
    }

    printf("\nConnecting to %s...\n", MBED_CONF_APP_WIFI_SSID);
    //ret = network->connect(MBED_CONF_APP_WIFI_SSID, MBED_CONF_APP_WIFI_PASSWORD, NSAPI_SECURITY_WPA_WPA2);
    //if (ret != 0) {
    //    printf("\nConnection error: %d\n", ret);
    //    return -1;
    //}
#endif
    printf("Waiting for 5 seconds before connecting...\n");
    for(int i=0;i<5;i++){
        printf("%d", i);
        wait(1);
    }

    //nsapi_error_t connect_status = network->connect();
    nsapi_error_t connect_status = network->connect(MBED_CONF_APP_WIFI_SSID, MBED_CONF_APP_WIFI_PASSWORD, NSAPI_SECURITY_WPA_WPA2);

    if (connect_status != NSAPI_ERROR_OK) {
        printf("[NWKH] Failed to connect to network (%d)\n", connect_status);
        return NULL;
    }

    printf("[NWKH] Connected to the network\n");
    printf("[NWKH] IP address: %s\n", network->get_ip_address());
    return network;
}

#endif // _MBED_HTTP_EXAMPLE_H_
