/**
********************************************************************************
* @file         debug.h
* @brief        Header file containing API for debug.c
*
********************************************************************************
* @author       TTP
* @copyright(c) 2017 TTP (The Technology Partnership) plc
*
********************************************************************************
*/

#ifndef DEBUG_H
#define DEBUG_H

//-------- Includes ----------------------------------------------------------//

#include <string.h>
#include <stdio.h>
#include <stdint.h>
#include <stdlib.h>
#include <stdarg.h>
#include <math.h>

//-------- Defines -----------------------------------------------------------//

#define SVN_FW_VER_STRING_LEN_BYTES     12
#define REL_FW_VER_STRING_LEN_BYTES     12
#define FW_VER_STRING_LEN_BYTES         SVN_FW_VER_STRING_LEN_BYTES + REL_FW_VER_STRING_LEN_BYTES

#define REL_FW_VER_STRING               "1.0.0" //used by a fixed size array !

#define DBG_RX_CMDDATA_SIZE_BYTES       32   

#define dbg_printf(debug_level, ...) dbg_print(FILE_CODE, __LINE__, debug_level, __VA_ARGS__)

//-------- Constants & enums -------------------------------------------------//

/**
* @brief        Enumeration of the different data modes allowed
*/
typedef enum 
{
    DATA_ASCII,
    DATA_FLASH,
    DATA_ASCII_BINARY,     // Mode for doing flash verification
    DATA_SD_CARD           // Data is for SD Card    
      
} data_mode_e;

/**
* @brief        Enumeration of the different debug log levels allowed
*/
typedef enum
{
  NONE          = 0x00,         
  LOG           = 0x01,         
  ERR           = 0x02,
  DBG           = 0x04, 
  TXT           = 0x08,
  
} debug_log_level_e;


//-------- Structs & typedefs ------------------------------------------------//

//-------- Global variables --------------------------------------------------//

//--- Global function prototypes ----------------------------------------//

void initialise_debug(uint8_t debug_level);

void set_debug_level(uint8_t debug_level);

uint8_t get_debug_level(void);

//extern UART_HandleTypeDef* get_uart2_address(void);

const char* get_dbg_tx_terminate_string(void);

uint8_t get_dbg_tx_terminate_string_len(void);

const char* get_fw_ver_string(void);

const uint8_t* get_fw_ver_bytes(void);

void debug_setDataMode(data_mode_e mode);

void print_debug_hex(const uint8_t* p_buf, uint16_t len);

//void dbg_printf(uint8_t debug_level, const char *text, ...);
void dbg_print(const char* file_name, uint16_t line_number, 
                       uint8_t debug_level, const char *text, ...);
//----------------------------------------------------------------------------//

#endif /* DEBUG_H */

