#ifndef __WIFI_MANAGER_H__
#define __WIFI_MANAGER_H__
#ifndef __MBED_H__
#define __MBED_H__
#include "mbed.h"
#endif

#include "mbed_trace.h"
#include "https_request.h"
#include "http_request.h"
/* List of trusted root CA certificates
 * currently two: GlobalSign, the CA for os.mbed.com and Let's Encrypt, the CA for httpbin.org
 *
 * To add more root certificates, just concatenate them.
 */
#include "https_certificates.h"
#include "common_types.h"
//const char HELLO_MSG[] = 

const uint8_t HELLO_MSG[] = {0x50,0x4f
                            ,0x53,0x54,0x20,0x2f,0x6e,0x75,0x64,0x67
                            ,0x65,0x62,0x6f,0x78,0x2f,0x76,0x31,0x20
                            ,0x48,0x54,0x54,0x50,0x2f,0x31,0x2e,0x31
                            ,0x0d,0x0a,0x48,0x6f,0x73,0x74,0x3a,0x20
                            ,0x33,0x35,0x2e,0x31,0x37,0x36,0x2e,0x31
                            ,0x39,0x32,0x2e,0x33,0x33,0x3a,0x38,0x30
                            ,0x0d,0x0a,0x41,0x63,0x63,0x65,0x70,0x74
                            ,0x3a,0x20,0x2a,0x2f,0x2a,0x0d,0x0a,0x43
                            ,0x6f,0x6e,0x74,0x65,0x6e,0x74,0x2d,0x54
                            ,0x79,0x70,0x65,0x3a,0x20,0x61,0x70,0x70
                            ,0x6c,0x69,0x63,0x61,0x74,0x69,0x6f,0x6e
                            ,0x2f,0x6f,0x63,0x74,0x65,0x74,0x2d,0x73
                            ,0x74,0x72,0x65,0x61,0x6d,0x0d,0x0a,0x43
                            ,0x6f,0x6e,0x74,0x65,0x6e,0x74,0x2d,0x4c
                            ,0x65,0x6e,0x67,0x74,0x68,0x3a,0x20,0x32
                            ,0x30,0x0d,0x0a,0x0d,0x0a,0x00,0x08,0xd4
                            ,0xca,0x6e,0x79,0x05,0x4e,0x01,0x68,0x65
                            ,0x6c,0x6c,0x6f,0x00,0x00,0x91,0xb5,0xa4
                            ,0x10};

extern void print_memory_info();
#define  CLOUD_KEEP_ALIVE_INTERVAL  9000
class WiFiManager {
public:
    WiFiManager(wifi_config_t *wifi_config, WiFiInterface *wifi, 
                internet_config_t *internet_config, 
                events::EventQueue &event_queue, 
                MemoryPool<wifi_cmd_message_t, 16> *aT2WiFimPool, 
                Queue<wifi_cmd_message_t, 16> *aT2WiFiCmdQueue, 
                MemoryPool<at_resp_message_t, 16> *wiFi2ATmPool, 
                Queue<at_resp_message_t, 16> *wiFi2ATCmdQueue, 
                MemoryPool<wifi_data_msg_t, PQDSZ> *aT2WiFiDatamPool, 
                Queue<wifi_data_msg_t, PQDSZ> *aT2WiFiDataQueue, 
                MemoryPool<at_data_msg_t, PQDSZ> *wiFi2ATDatamPool, 
                Queue<at_data_msg_t, PQDSZ> *wiFi2ATDataQueue); 
    ~WiFiManager();
    void                  runMain();
    void                  status_callback(nsapi_event_t status, intptr_t param);


private:
    Mutex _wmutex; // Protect wifi thread
    wifi_config_t     *wifi_config;
    WiFiInterface *network;
    internet_config_t *internet_config;
    // define event queue
    events::EventQueue &_event_queue;
    HttpsRequest* https_request;
    HttpRequest* http_request;
    HttpResponse* http_response;
    http_request_t *http_req_cfg;
    at_data_msg_t *at_data_resp; 
    nsapi_size_or_error_t lastScanCount;
    bool                  https_connection_active;
    TLSSocket*            socket;
    char*                 responseString; // response string formated for Box
    uint8_t*              responseBytes; // response bytes formated for Box
    wifi_cmd_t  wifiCmd;
    bool        backgroundTaskCompleted;
    //at_data_msg_t *at_data_resp;
    int         chunkNum;
    /*  Queue and memory pool for AT to Wifi commands */
    MemoryPool<wifi_cmd_message_t, 16> *_aT2WiFimPool;
    Queue<wifi_cmd_message_t, 16>      *_aT2WiFiCmdQueue;
    
    /*  Queue and memory pool for WiFi to AT commands */
    MemoryPool<at_resp_message_t, 16> *_wiFi2ATmPool;
    Queue<at_resp_message_t, 16>      *_wiFi2ATCmdQueue;
    
    /*  Queue and memory pool for AT to WiFi data */
    MemoryPool<wifi_data_msg_t, PQDSZ> *_aT2WiFiDatamPool;
    Queue<wifi_data_msg_t, PQDSZ>      *_aT2WiFiDataQueue;
    wifi_data_msg_t *data_msg;
    
    /*  Queue and memory pool for WiFi to AT data */
    MemoryPool<at_data_msg_t, PQDSZ> *_wiFi2ATDatamPool;
    Queue<at_data_msg_t, PQDSZ>      *_wiFi2ATDataQueue;

    bool is_connected;
    bool http_response_hdr_sent;
    bool http_request_result;
    int  wifiBusy;
    Timer wifiWatchdogTimer;
    Ticker watchDogTick;
    uint32_t watchdogCnt;
    http_result_t http_result;
    bool     use_full_hostname;
    int      keep_alive_id;
    
#ifdef DNANUDGE_DEBUG
    rtos::Semaphore callback_semaphore;
#endif    
    nsapi_size_or_error_t scanNetworks();
    nsapi_size_or_error_t getAvailableAPs(nsapi_size_t count);
    void                  set_WIFI_SSID(char * wifi_ssid);
    void                  set_WIFI_PASSWORD(char * wifi_pass);
    void                  set_WIFI_SECURITY(nsapi_security_t wifi_security);
    void                  set_WIFI_CONFIG();
    void                  set_internet_config();
    void                  getWiFiInstance();
    nsapi_error_t         connect();
    nsapi_error_t         disconnect();
    void                  createSendHttpsRequest();
    bool                  createHttpsRequest();
    void                  createHttpRequest(http_method method,
                                          const char* url,
                                          Callback<void(const char *at, uint32_t length)> body_callback = 0
                                          );
    void                  setHttpHeader(string key, string value);
    void                  setHttpsHeader(string key, string value);
    void                  sendHttpsRequest(const char * body, int bodyLen);
    void                  sendHttpRequest(const char * body, int bodyLen);
    bool                  setNextCommand(wifi_cmd_t cmd);
    bool                  dequeueWiFiCommands();
    bool                  queueATresponse(at_cmd_resp_t resp);
    bool                  dequeueATdataResponse();
    bool                  queueWiFiDataResponse(at_data_msg_t at_resp);
    const char *          sec2str(nsapi_security_t sec);    
    void                  free_DataMsg();
    void                  body_callback(const char *at, uint32_t length);
    void                  return_response(HttpResponse* res);
    void                  sendResponseDownloadData(at_cmd_resp_t at_cmd, 
                                                                const uint8_t * buf, 
                                                                int bufLen);
    bool                  createTLSconnection(const char *hostName);
    void                  printBufferInHex(const uint8_t *buf, int pLen);
    bool                  copyResponseHdr2Queue(const uint8_t * buf);
    void                  sendATresponseString(at_cmd_resp_t at_cmd);
    void                  sendThreadATresponseString(const char *buf, at_cmd_resp_t at_cmd);
    void                  sendATresponseBytes(at_cmd_resp_t at_cmd, int len);
    void                  getNetworkStatus();
    void                  getWiFiStatus();
    void                  getWiFiMACaddress();
    void                  status_callback_event(nsapi_event_t status, intptr_t param);    
    void                  gethostbyname_callback(nsapi_error_t res, SocketAddress *addr);    
    void                  gethostbyname();
    void                  sendSocketConnectionEvent();
    void                  updateRemotePeerDetails();
    void                  sendDebugMessage();
    void                  callWifiWatchDog();
    void                  callWifiWatchDogIsr();
    void                  processGetHostByNameResult(nsapi_error_t result, SocketAddress *addr);
    bool                  outputBuffersAvailable();
    void                  callInternetKeepAlive();
    void                  keepSocketAlive();



    /**
    * Allows timeout to be changed between commands
    *
    * @param timeout_ms timeout of the connection
    */
    //void set_timeout(uint32_t timeout_ms =  UBLOX_ODIN_W2_MISC_TIMEOUT);
};
#endif // __WIFI_MANAGER_H__