#ifndef __COMMON_CONFIG_H__
#define __COMMON_CONFIG_H__

#define DEFAULT_BAUD_RATE   115200
#define MAX_BLE_PACKET_SIZE   256
#define TX_BUFFER_LEN 4*256
#define RX_BUFFER_LEN 4*256
#define BTLE_THREAD_PRIORITY osPriorityRealtime
#define WIFI_THREAD_PRIORITY osPriorityRealtime
#define ATCMD_THREAD_PRIORITY osPriorityHigh
#ifndef UBLOX_ODIN_W2_RECV_TIMEOUT
#define UBLOX_ODIN_W2_RECV_TIMEOUT    5
#endif
#define USE_MALLOC_FOR_COMMAND_MEMORY_POOL
#define WIFI_CONNECT_TIMEOUT_SECS 30
#define MAIN_LOOP_WAIT_TIME_MS 100 // milliseconds
#define WIFI_MAIN_LOOP_WAIT_TIME_MS 101 // milliseconds
#define MAX_RESPONSE_STRING_LEN   512 // maximum response string length of 512 bytes
#define DEFAULT_WIFI_CHANNEL      0
#define DEFAULT_BTLE_CHANNEL      1
#define WIFI_LINK_ENABLED         "+UUWLE:"
#define WIFI_LINK_DISABLED        "+UUWLD:"
#define NETWORK_UP_URC            "+UUNU"
#define NETWORK_DOWN_URC          "+UUND"
#define PEER_CONNECTED_URC        "+UUDPC:"
#define PEER_DISCONNECTED_URC     "+UUDPD:"
#define NETWORK_STATUS            "+UNSTAT:"
#define WIFI_NETWORK_STATUS       "+UWSSTAT:"
#define UDDRP_ERROR               "\r\nERROR\r\n"
#define UDDRP_WRITE_OK            "\r\nOK\r\n" 
#define HOSTNAME_RESPONSE_LEN     14
#define WIFI_STATION              1
#define WIFI_CONFIG_ID            0
#define WIFI_INTERFACE_ID         0
#define DEFAULT_DNS_ADDRESS       "0.0.0.0"
#define BLE_CONNECTION            1
#define TCP_PROTOCOL              0
#define UDP_PROTOCOL              1
#define IPv4_CONNECTION           0x02
#define IP_PEER_HANDLE            0x02
#define BTLE_PEER_HANDLE          0x01
#define GATT_TYPE                 0x00
#define BLE_UUID_PROFILE          3
#define BLE_FRAME_SIZE            64
#define DEFAULT_LOCAL_PORT        0
#define PQDSZ                     2  // size of Wifi Pool/Queue data structures
#define PQDSZ_BLE                 8  // size of BLE Pool/Queue data structures
#define MAX_HTTP_HDR_LEN          512
#define HTTP_HEADER_START_LINE    "HTTP/1.1 "
#define HTTP_HEADER_CONTENT_TYPE  "Content-Type:"
#define HTTP_HEADER_CONTENT_LEN   "Content-Length:"
#define QUEUE_WAIT_TIMEOUT_MS     1000
#define CLOUD_RETRY_TIME_MS       10000
#define MAX_BLE_POOL_DATA_SIZE    40
#define BLE_PROCESS_QUEUES_INTERVAL_MS  200 // check BLE queues every 200 ms
#define BLE_IF_ID                       1
#define WIFI_IF_ID                      2
#define LOCAL_ADDRESS_RESP              "+UMLA:"
#define BLE_DEVICE_NAME_RESP            "+UBTLN:"
#define ATCMD_MGR_FULL_DEBUG_ENA        0x01
#define WIFI_MGR_FULL_DEBUG_ENA         0x02
#define BTLE_MGR_FULL_DEBUG_ENA         0x04
#define ONE_SECOND                      1000 // 1000 ms
#define HTTPS_URL_PREFIX                "https://"
#define TLS_RETRY_TIMEOUT_MS            2000
//#define ENABLE_MEMORY_CHECKS
//#define SEND_DEBUG_MESSAGES

#define TRIM_AWS_HEADER_ENTRIES
#define SEND_CLOUD_OK_MSG
typedef enum
{
  IF_HW_ADDRESS = 0,
  NETWORK_IF_STATUS = 1,
  INTERFACE_TYPE = 2,
  IPv4_ADDRESS = 101,
  SUBNET_MASK = 102,
  GATEWAY_ADDRESS = 103,
  PRIMARY_DNS_SERVER = 104,
  SECONDARY_DNS_SERVER = 105,
  IPv6_ADDRESS = 201
}net_stat_id_t;

typedef enum
{
  WIFI_SSID = 0,
  WIFI_BSSID = 1,
  WIFI__CURRENT_CHANNEL = 2,
  WIFI_STA_STATUS = 3,
  WIFI_RSSI = 6
}wifi_stat_id_t;

const net_stat_id_t netStatusIds[]  =  {IF_HW_ADDRESS, NETWORK_IF_STATUS, 
                                        INTERFACE_TYPE, IPv4_ADDRESS, 
                                        SUBNET_MASK, GATEWAY_ADDRESS, 
                                        PRIMARY_DNS_SERVER, SECONDARY_DNS_SERVER, 
                                        IPv6_ADDRESS};
                                        
                                        
const int NumNetworkStatus    = sizeof(netStatusIds)/sizeof(uint8_t);


const wifi_stat_id_t wifiStatusIds[] = {WIFI_SSID, WIFI_BSSID, 
                                        WIFI__CURRENT_CHANNEL, WIFI_STA_STATUS, 
                                        WIFI_RSSI};

const int NumWiFiStatus    = sizeof(wifiStatusIds)/sizeof(uint8_t);

const uint8_t hello_msg[] = {0xaa,0x00,0x96,0x00,0x36,0x00,0x50,0x4f
                            ,0x53,0x54,0x20,0x2f,0x6e,0x75,0x64,0x67
                            ,0x65,0x62,0x6f,0x78,0x2f,0x76,0x31,0x20
                            ,0x48,0x54,0x54,0x50,0x2f,0x31,0x2e,0x31
                            ,0x0d,0x0a,0x48,0x6f,0x73,0x74,0x3a,0x20
                            ,0x33,0x35,0x2e,0x31,0x37,0x36,0x2e,0x31
                            ,0x39,0x32,0x2e,0x33,0x33,0x3a,0x38,0x30
                            ,0x0d,0x0a,0x41,0x63,0x63,0x65,0x70,0x74
                            ,0x3a,0x20,0x2a,0x2f,0x2a,0x0d,0x0a,0x43
                            ,0x6f,0x6e,0x74,0x65,0x6e,0x74,0x2d,0x54
                            ,0x79,0x70,0x65,0x3a,0x20,0x61,0x70,0x70
                            ,0x6c,0x69,0x63,0x61,0x74,0x69,0x6f,0x6e
                            ,0x2f,0x6f,0x63,0x74,0x65,0x74,0x2d,0x73
                            ,0x74,0x72,0x65,0x61,0x6d,0x0d,0x0a,0x43
                            ,0x6f,0x6e,0x74,0x65,0x6e,0x74,0x2d,0x4c
                            ,0x65,0x6e,0x67,0x74,0x68,0x3a,0x20,0x32
                            ,0x30,0x0d,0x0a,0x0d,0x0a,0x00,0x08,0xd4
                            ,0xca,0x6e,0x79,0x05,0x4e,0x01,0x68,0x65
                            ,0x6c,0x6c,0x6f,0x00,0x00,0x91,0xb5,0xa4
                            ,0x10,0x55};
#endif // __COMMON_CONFIG_H__