#ifndef __COMMON_TYPES_H__
#define __COMMON_TYPES_H__
#include <mbed.h>
#include <string>
#include "ble/BLE.h"
#include "SecurityManager.h"
#include "common_config.h"
#define BLE_MAX_DEVICE_NAME_LEN 10
#define MAX_SSID_LEN 32
#define MAX_PASSKEY_LEN 32

/** ble configuration structure
*/
typedef struct ble_config {
    char      deviceName[BLE_MAX_DEVICE_NAME_LEN]; /* BLE Device Name */
    uint16_t  advInterval; /* advertising interval in msecs */
    uint16_t  advTimeout;  /* advertising timeout in secs */
    //Passkey_t pairingKey;  /* pairing Key */
    uint8_t   pairingKey[6];  /* pairing Key */
} ble_config_t;

/** ble configuration structure
*/
typedef struct wifi_config {
    char             ssid[MAX_SSID_LEN]; /* WiFi SSID */
    char             pass[MAX_PASSKEY_LEN]; /* WiFi Passkey */
    nsapi_security_t security;  /* WiFi security */
} wifi_config_t;

/** ble configuration structure
*/
typedef struct app_config {
    wifi_config_t wifi_config; /* wifi configuration */
    ble_config_t ble_config;   /* ble configuration */
} app_config_t;


typedef enum wifi_cmd
{
  WIFI_CMD_NONE,
  WIFI_CMD_CONFIG,
  WIFI_CMD_INTERNET_CONFIG,
  WIFI_CMD_SCAN,
  WIFI_CMD_DETAILED_SCAN,
  WIFI_CMD_CONNECT,
  WIFI_CMD_DISCONNECT,
  WIFI_CMD_SEND_HTTPS_REQ,
  WIFI_CMD_SEND_HTTP_REQ
}wifi_cmd_t;

typedef enum at_cmd_resp
{
  AT_RESP_NONE,
  AT_SCAN_RESP,
  AT_DETAILED_SCAN_RESP,
  AT_CONNECT_RESP,
  AT_DISCONNECT_RESP,
  WIFI_RECONNECT_INFO,
  WIFI_DISCONNECT_INFO,
  AT_CONFIG_RESP,
  AT_INTERNET_CONFIG_RESP,
  AT_HTTPS_RESP,
  AT_HTTP_RESP
}at_cmd_resp_t;


typedef enum at_data_mode
{
  AT_CMD_DATA_MODE,
  AT_STD_DATA_MODE,
  AT_EXT_DATA_MODE
}at_data_mode_t;

typedef enum conn_scheme
{
  INVALID_SCHEME,
  ALWAYS_CONNECTED,
  EXTERNAL_CONNECT
}conn_scheme_t;


typedef struct {
    wifi_cmd_t    wifi_cmd;   /* wifi command */
} wifi_cmd_message_t;

typedef struct {
    at_cmd_resp_t    at_resp;   /* AT response */
} at_resp_message_t;

typedef struct {
    wifi_cmd_t    wifi_cmd;              /* wifi data command */
    int           dataLen;              /* size of data in buffer */
    uint8_t       buffer[TX_BUFFER_LEN]; /* buffer length     */
} wifi_data_msg_t;

typedef struct {
    at_cmd_resp_t at_resp;              /* AT response */
    int           dataLen;              /* size of data in buffer */
    uint8_t       buffer[TX_BUFFER_LEN]; /* buffer length     */
} at_data_msg_t;

typedef struct {
    string        hostName;     /* host name */
    string        contentType;  /* content type */
    int           bodyLen;      /* body length     */
    uint8_t       body[900];    /* body     */
} http_post_request_t;

typedef struct {
    string        contentType;  /* content type */
    int           bodyLen;      /* body length     */
    uint8_t       body[900];    /* body     */
} http_response_t;

typedef struct {
    uint8_t       peer_id          ;  /* peer id */
    conn_scheme_t connectionScheme;   /* connection scheme     */
    string        url;          /* body     */
} internet_config_t;


#endif  // __COMMON_TYPES_H__