#ifndef __WIFI_MANAGER_H__
#define __WIFI_MANAGER_H__
#ifndef __MBED_H__
#define __MBED_H__
#include "mbed.h"
#endif

#include "mbed_trace.h"
#include "https_request.h"
#include "http_request.h"
/* List of trusted root CA certificates
 * currently two: GlobalSign, the CA for os.mbed.com and Let's Encrypt, the CA for httpbin.org
 *
 * To add more root certificates, just concatenate them.
 */
#include "https_certificates.h"
#include "common_types.h"


class WiFiManager {
public:
    WiFiManager(wifi_config_t wifi_config, WiFiInterface *wifi, 
                MemoryPool<wifi_cmd_message_t, 16> *aT2WiFimPool, 
                Queue<wifi_cmd_message_t, 16> *aT2WiFiCmdQueue, 
                MemoryPool<at_resp_message_t, 16> *wiFi2ATmPool, 
                Queue<at_resp_message_t, 16> *wiFi2ATCmdQueue, 
                MemoryPool<wifi_data_msg_t, 4> *aT2WiFiDatamPool, 
                Queue<wifi_data_msg_t, 4> *aT2WiFiDataQueue, 
                MemoryPool<at_data_msg_t, 4> *wiFi2ATDatamPool, 
                Queue<at_data_msg_t, 4> *wiFi2ATDataQueue); 
    ~WiFiManager();
    void                  runMain();
    void                  status_callback(nsapi_event_t status, intptr_t param);
    


private:
    wifi_config_t     wifi_config;
    internet_config_t internet_config;
    WiFiInterface *network;
    HttpsRequest* https_request;
    HttpRequest* http_request;
    HttpResponse* http_response;
    nsapi_size_or_error_t lastScanCount;
    wifi_cmd_t  wifiCmd;
    /*  Queue and memory pool for AT to Wifi commands */
    MemoryPool<wifi_cmd_message_t, 16> *_aT2WiFimPool;
    Queue<wifi_cmd_message_t, 16> *_aT2WiFiCmdQueue;
    
    /*  Queue and memory pool for WiFi to AT commands */
    MemoryPool<at_resp_message_t, 16> *_wiFi2ATmPool;
    Queue<at_resp_message_t, 16> *_wiFi2ATCmdQueue;
    
    /*  Queue and memory pool for AT to WiFi data */
    MemoryPool<wifi_data_msg_t, 4> *_aT2WiFiDatamPool;
    Queue<wifi_data_msg_t, 4> *_aT2WiFiDataQueue;
    wifi_data_msg_t *data_msg;
    
    /*  Queue and memory pool for WiFi to AT data */
    MemoryPool<at_data_msg_t, 4> *_wiFi2ATDatamPool;
    Queue<at_data_msg_t, 4> *_wiFi2ATDataQueue;

    bool is_connected;
    
    nsapi_size_or_error_t scanNetworks();
    nsapi_size_or_error_t getAvailableAPs(nsapi_size_t count);
    void                  set_WIFI_SSID(char * wifi_ssid);
    void                  set_WIFI_PASSWORD(char * wifi_pass);
    void                  set_WIFI_SECURITY(nsapi_security_t wifi_security);
    void                  set_WIFI_CONFIG();
    void                  set_internet_config();
    nsapi_error_t         connect();
    nsapi_error_t         disconnect();
    void                  createHttpsRequest(http_method method,
                                           const char* url,
                                           Callback<void(const char *at, uint32_t length)> body_callback = 0
                                           );
    void                  createHttpRequest(http_method method,
                                          const char* url,
                                          Callback<void(const char *at, uint32_t length)> body_callback = 0
                                          );
    void                  setHttpHeader(string key, string value);
    void                  setHttpsHeader(string key, string value);
    void                  sendHttpsRequest(const char * body, int bodyLen);
    void                  sendHttpRequest(const char * body, int bodyLen);
    bool                  setNextCommand(wifi_cmd_t cmd);
    bool                  dequeueWiFiCommands();
    bool                  queueATresponse(at_cmd_resp_t resp);
    bool                  dequeueATdataResponse();
    bool                  queueWiFiDataResponse(at_data_msg_t at_resp);
    const char *          sec2str(nsapi_security_t sec);    
    void                  free_DataMsg();

    /**
    * Allows timeout to be changed between commands
    *
    * @param timeout_ms timeout of the connection
    */
    //void set_timeout(uint32_t timeout_ms =  UBLOX_ODIN_W2_MISC_TIMEOUT);
};
#endif // __WIFI_MANAGER_H__