#ifndef __ATCMD_MANAGER_H__
#define __ATCMD_MANAGER_H__
#include <events/mbed_events.h>
#include <mbed.h>
#include "ATCmdParser.h"
#include "BleManager.h"
#include "WiFiManager.h"

#define MAIN_LOOP_WAIT_TIME_MS 1000 // milliseconds
#define NUM_UART_OPTIONS       6
#ifndef UBLOX_ODIN_W2_MISC_TIMEOUT
#define UBLOX_ODIN_W2_MISC_TIMEOUT    2000
#endif


class ATCmdManager {
public:
    ATCmdManager(PinName tx, PinName rx, SMDevicePeripheral *blePeripheral, 
                 events::EventQueue &event_queue, WiFiManager *wifi, 
                 MemoryPool<wifi_cmd_message_t, 16> *aT2WiFimPool, 
                 Queue<wifi_cmd_message_t, 16> *aT2WiFiCmdQueue, 
                 MemoryPool<at_resp_message_t, 16> *wiFi2ATmPool, 
                 Queue<at_resp_message_t, 16> *wiFi2ATCmdQueue, 
                 MemoryPool<wifi_data_msg_t, 4> *aT2WiFiDatamPool, 
                 Queue<wifi_data_msg_t, 4> *aT2WiFiDataQueue, 
                 MemoryPool<at_data_msg_t, 4> *wiFi2ATDatamPool, 
                 Queue<at_data_msg_t, 4> *wiFi2ATDataQueue, 
                 bool debug = false);
public:
    void runMain();



private:
// UART settings
    UARTSerial _serial;
    Mutex _smutex; // Protect serial port access
    Mutex _rmutex; // Reset protection
    // define event queue
    events::EventQueue &_event_queue;
    // AT Command Parser
    ATCmdParser _parser;
    SMDevicePeripheral *blePeripheral;
    WiFiManager *wiFiManager;
    at_cmd_resp_t at_resp;
    at_data_mode_t dataMode;
    /*  Queue and memory pool for AT to Wifi commands */
    MemoryPool<wifi_cmd_message_t, 16> *_aT2WiFimPool;
    Queue<wifi_cmd_message_t, 16> *_aT2WiFiCmdQueue;
    
    /*  Queue and memory pool for WiFi to AT commands */
    MemoryPool<at_resp_message_t, 16> *_wiFi2ATmPool;
    Queue<at_resp_message_t, 16> *_wiFi2ATCmdQueue;
    
    /*  Queue and memory pool for AT to WiFi data */
    MemoryPool<wifi_data_msg_t, 4> *_aT2WiFiDatamPool;
    Queue<wifi_data_msg_t, 4> *_aT2WiFiDataQueue;
    
    
    /*  Queue and memory pool for WiFi to AT data */
    MemoryPool<at_data_msg_t, 4> *_wiFi2ATDatamPool;
    Queue<at_data_msg_t, 4> *_wiFi2ATDataQueue;
    
    //pointer to response data - should be deleted after processing
    at_data_msg_t *resp_data;

    
    // OOB processing
    void _process_oob(uint32_t timeout, bool all);
    // OOB message handlers
    void _oob_startup_hdlr();
    void _oob_ok_hdlr();
    void _oob_bleRole_hdlr();
    void _oob_wifiMode_err();
    void _oob_conn_already();
    void _oob_err();
    void _oob_echo_off();
    void _oob_uart_setup();
    void _oob_echo_on();
    void _oob_data_mode();
    void _oob_get_mac_addr();
    void _oob_get_ble_role();
    void _oob_ena_ble_peri();
    void _oob_reboot();
    void _oob_get_fw_ver();
    void _oob_scanWiFiNetworks();
    void _oob_connect2WiFiNetwork();
    void _oob_disconnectWiFiNetwork();
    void _oob_setupInternetConnection();
    void _oob_setWiFiSSID();
    void _oob_setWiFiPWD();
    void _oob_setWiFiSecurity();
    wifi_config_t init_wifi_config();
    const char * sec2str(nsapi_security_t sec);
    bool  queueWiFiCommand(wifi_cmd_t cmd);
    bool  dequeueATresponse();
    bool  queueWiFiDataRequest(wifi_data_msg_t cmd);
    bool  dequeueATdataResponse();
    void  processResponses();
    bool  setNextResponse(at_cmd_resp_t resp);    
    int   readBytes(uint8_t *buf, int maxBytes);

    
    /**
    * Allows timeout to be changed between commands
    *
    * @param timeout_ms timeout of the connection
    */
    void set_timeout(uint32_t timeout_ms =  UBLOX_ODIN_W2_MISC_TIMEOUT);
};
#endif // __ATCMD_MANAGER_H__