#ifndef __COMMON_TYPES_H__
#define __COMMON_TYPES_H__
#include <mbed.h>
#define BLE_MAX_DEVICE_NAME_LEN 10
#define MAX_SSID_LEN 32
#define MAX_PASSKEY_LEN 32

/** ble configuration structure
*/
typedef struct ble_config {
    char     deviceName[BLE_MAX_DEVICE_NAME_LEN]; /* BLE Device Name */
    uint16_t advInterval; /* advertising interval in msecs */
    uint16_t advTimeout;  /* advertising timeout in secs */
} ble_config_t;

/** ble configuration structure
*/
typedef struct wifi_config {
    char             ssid[MAX_SSID_LEN]; /* WiFi SSID */
    char             pass[MAX_PASSKEY_LEN]; /* WiFi Passkey */
    nsapi_security_t security;  /* WiFi security */
} wifi_config_t;

/** ble configuration structure
*/
typedef struct app_config {
    wifi_config_t wifi_config; /* wifi configuration */
    ble_config_t ble_config;   /* ble configuration */
} app_config_t;


#endif  // __COMMON_TYPES_H__