#ifndef __WIFI_MANAGER_H__
#define __WIFI_MANAGER_H__
#include "common_types.h"

class WiFiManager {
public:
    WiFiManager(wifi_config_t wifi_config, WiFiInterface *wifi);
    ~WiFiManager();
    void scanChannels();
    void getAvailableAPs();
    void set_WIFI_SSID(char * wifi_ssid);
    void set_WIFI_PASSWORD(char * wifi_pass);
    void set_WIFI_SECURITY(nsapi_security_t wifi_security);
    void connect();
    void disconnect();
    void sendHttpsRequest();
    void sendHttpRequest();



private:
    wifi_config_t wifi_config;
    WiFiInterface *network;
    /**
    * Allows timeout to be changed between commands
    *
    * @param timeout_ms timeout of the connection
    */
    //void set_timeout(uint32_t timeout_ms =  UBLOX_ODIN_W2_MISC_TIMEOUT);
};
#endif // __WIFI_MANAGER_H__