#ifndef __ATCMD_MANAGER_H__
#define __ATCMD_MANAGER_H__
#include <mbed.h>
#include "ATCmdParser.h"
#include "BleManager.h"
#include "WiFiManager.h"

#define MAIN_LOOP_WAIT_TIME_MS 1000 // milliseconds
#define NUM_UART_OPTIONS       6
#ifndef UBLOX_ODIN_W2_MISC_TIMEOUT
#define UBLOX_ODIN_W2_MISC_TIMEOUT    2000
#endif


class ATCmdManager {
public:
    ATCmdManager(PinName tx, PinName rx, SMDevicePeripheral *blePeripheral, 
                 WiFiManager *wifi, bool debug = false);
public:
    void runMain();



private:
// UART settings
    UARTSerial _serial;
    Mutex _smutex; // Protect serial port access
    Mutex _rmutex; // Reset protection

    // AT Command Parser
    ATCmdParser _parser;
    SMDevicePeripheral *blePeripheral;
    WiFiManager *wifi;
    // OOB processing
    void _process_oob(uint32_t timeout, bool all);
    // OOB message handlers
    void _oob_startup_hdlr();
    void _oob_bleRole_hdlr();
    void _oob_wifiMode_err();
    void _oob_conn_already();
    void _oob_err();
    void _oob_echo_off();
    void _oob_uart_setup();
    void _oob_echo_on();
    void _oob_data_mode();
    void _oob_get_mac_addr();
    void _oob_get_ble_role();
    void _oob_ena_ble_peri();
    void _oob_reboot();
    void _oob_get_fw_ver();
    
    /**
    * Allows timeout to be changed between commands
    *
    * @param timeout_ms timeout of the connection
    */
    void set_timeout(uint32_t timeout_ms =  UBLOX_ODIN_W2_MISC_TIMEOUT);
};
#endif // __ATCMD_MANAGER_H__