#include "ATCmdManager.h"
#include "common_config.h"

ATCmdManager::ATCmdManager(PinName tx, PinName rx, SMDevicePeripheral *blePeripheral, 
                           WiFiManager *wifi, bool debug)
    :
    _serial(tx, rx, DEFAULT_BAUD_RATE),
    _parser(&_serial),
    blePeripheral(blePeripheral),
    wifi(wifi)

{ 
// constructor
    _serial.set_baud(DEFAULT_BAUD_RATE);
    _parser.debug_on(debug);
    _parser.set_delimiter("\r\n");
    _parser.send("+STARTUP");
    _parser.oob("ATE0", callback(this, &ATCmdManager::_oob_echo_off));
    _parser.oob("ATE1", callback(this, &ATCmdManager::_oob_echo_on));
    _parser.oob("AT+UMRS", callback(this, &ATCmdManager::_oob_uart_setup));
    
    _parser.oob("ATO", callback(this, &ATCmdManager::_oob_data_mode));
    _parser.oob("AT+UMLA", callback(this, &ATCmdManager::_oob_get_mac_addr));
    _parser.oob("AT+UBTLE?", callback(this, &ATCmdManager::_oob_get_ble_role));
    _parser.oob("AT+UBTLE=2", callback(this, &ATCmdManager::_oob_ena_ble_peri));
    _parser.oob("AT+CPWROFF", callback(this, &ATCmdManager::_oob_reboot));
    _parser.oob("AT+CGMR", callback(this, &ATCmdManager::_oob_get_fw_ver));
    

    //_parser.oob("ATE0", callback(this, &ATCmdManager::_oob_startup_hdlr));
    printf("\n --- ATCmdManager constructor completed ---\n");
    
    //AT+UMRS=230400,2,8,1,1,1
    // AT+UBTLE
}


void ATCmdManager::runMain(){
    while(true){
        _process_oob(UBLOX_ODIN_W2_RECV_TIMEOUT, true);
        wait_ms(MAIN_LOOP_WAIT_TIME_MS); // allow BTLE to be
    }
    
}


// OOB processing
void ATCmdManager::_process_oob(uint32_t timeout, bool all){
    set_timeout(timeout);
    // Poll for inbound packets
    while (_parser.process_oob() && all) {
    }
    set_timeout();
}


// OOB message handlers
void ATCmdManager::_oob_startup_hdlr(){
}


void ATCmdManager::_oob_bleRole_hdlr(){
}


void ATCmdManager::_oob_wifiMode_err(){
}


void ATCmdManager::_oob_conn_already(){
}


void ATCmdManager::_oob_err(){
}

void ATCmdManager::_oob_uart_setup(){
    int uOpts[NUM_UART_OPTIONS];
    //if(_parser.recv("=%d,%d,%d,%d,%d,%d", &uOpts[0], &uOpts[1], &uOpts[2], &uOpts[3], &uOpts[4], &uOpts[5])) {
    if(_parser.scanf("=%d,%d,%d,%d,%d,%d", &uOpts[0], &uOpts[1], &uOpts[2], &uOpts[3], &uOpts[4], &uOpts[5]) >0) {
        printf("\nATCmdParser: Uart Options=%d,%d,%d,%d,%d,%d\n", uOpts[0], uOpts[1], uOpts[2], uOpts[3], uOpts[4], uOpts[5]);
    } else {
        printf("\nATCmdParser: Retrieving Uart Options failed");
    }
}

void ATCmdManager::set_timeout(uint32_t timeout_ms)
{
    _parser.set_timeout(timeout_ms);
}


void ATCmdManager::_oob_echo_off()
{
    _smutex.lock();
    printf("\n Received ATEO OOB command!!\n");
    printf("\n turning echo OFF!!\n");
    _parser.debug_on(false);
    _parser.send("OK\n");
    _smutex.unlock();
}


void ATCmdManager::_oob_echo_on()
{
    _smutex.lock();
    printf("\n Received ATE1 OOB command!!\n");
    printf("\n turning echo ON!!\n");
    _parser.debug_on(true);
    _parser.send("OK\n");
    _smutex.unlock();
}


void ATCmdManager::_oob_data_mode(){
    int dataMode;
    _smutex.lock();
    printf("\n Received EDM mode command!!\n");
    if(_parser.scanf("%d", &dataMode) >0) {
        printf("\nATCmdParser: Data mode=%d\n", dataMode);
        switch(dataMode)
        {
            case 0:
                printf("\nATCmdParser: Command Mode request received");
                break;
            case 1:
                printf("\nATCmdParser: Data Mode request received");
                break;
            case 2:
                printf("\nATCmdParser: Extended data Mode request received");
                break;
            default:
                printf("\nATCmdParser: ERROR - UNKNOWN DATA MODE RECEIVED!!! \n");
                break;
        }
    } else {
        printf("\nATCmdParser: Retrieving Uart Options failed");
    }
    _parser.send("OK\n");
    _smutex.unlock();
}

void ATCmdManager::_oob_get_mac_addr(){
    int bleOrWifi;
    _smutex.lock();
    if(_parser.scanf("=%d", &bleOrWifi) >0) {
        switch(bleOrWifi)
        {
            case 1:
                printf("\nATCmdParser: BLE MAC Address request received");
                break;
            case 2:
                printf("\nATCmdParser: WiFi MAC Address request received");
                break;
            default:
                printf("\nATCmdParser: ERROR - UNKNOWN MAC ADDRESS REQUEST RECEIVED!!! \n");
                break;
        }
    } else {
        printf("\nATCmdParser: Retrieving Uart Options failed");
    }
    _parser.send("OK\n");
    _smutex.unlock();
}

void ATCmdManager::_oob_get_ble_role(){
    _smutex.lock();
    printf("\n Received get BLE role command!!\n");
    _parser.send("OK\n");
    _smutex.unlock();
}

void ATCmdManager::_oob_ena_ble_peri(){
    _smutex.lock();
    printf("\n Received enable BLE Peripheral command!!\n");
    _parser.send("OK\n");
    _smutex.unlock();
}

void ATCmdManager::_oob_reboot(){
    _smutex.lock();
    printf("\n Received reboot command!!\n");
    _parser.send("OK\n");
    _parser.send("System Resetting....\n");
    system_reset();
    _smutex.unlock();
}

void ATCmdManager::_oob_get_fw_ver(){
    _smutex.lock();
    printf("\n Received Firmware Version command!!\n");
    _parser.send("OK\n");
    _smutex.unlock();
}

