#include "mbed.h"
#include "USBMouse.h"
#include "FXOS8700Q.h"

//I2C lines for FXOS8700Q accelerometer/magnetometer
FXOS8700Q_acc acc( PTE25, PTE24, FXOS8700CQ_SLAVE_ADDR1);
DigitalIn leftbutton(SW2); //SW2 will be assigned to the left mouse button
DigitalIn rightbutton(SW3); //SW3 will be assigned to the right mouse button


USBMouse mouse;
 
int main() 
{
    acc.enable(); //enable the accelerometer
    float faX, faY, faZ; 
    int16_t x = 0;
    int16_t y = 0;
    
    while (1) 
    {
        //acc.getAxis(acc_data);
        acc.getX(&faX);
        acc.getY(&faY);
        acc.getZ(&faZ);
        x = 10*faX;
        y = 10*faY;
        
        mouse.move(x, y); //move mouse dependant on the postion of the rotation of the mbed
        
        if(leftbutton==0){
            mouse.press(MOUSE_LEFT);
            }
        else{mouse.release(MOUSE_LEFT);}
        
        if(rightbutton==0){
            mouse.press(MOUSE_RIGHT);
            }
        else{mouse.release(MOUSE_RIGHT);}
        
        wait(0.001); //updates position every 0.001 seconds
    }
}