/* Sets the mbed up as Slave, and exchanges data with a Master,
sending its own switch positions, and displaying those of the Master. as SPI slave.*/
#include "mbed.h"
SPISlave ser_port(PTD2,PTD3,PTD1,PTC16); // mosi, miso, sclk, ssel
DigitalOut red_led(LED1); //red led
DigitalOut green_led(LED2); //green led
DigitalIn switch_ip1(SW2);
DigitalIn switch_ip2(SW3);
char switch_word ; //word we will send
char recd_val; //value received from master

int main() {
    recd_val=0x00;
//default formatting applied
   while(1) {
//set up switch_word from switches that are pressed
   switch_word=0xa0; //set up a recognizable output pattern
    if (switch_ip1==0)
    switch_word=switch_word|0x01;
    if (switch_ip2==0)
   switch_word=switch_word|0x02;
    if(ser_port.receive()) { //test if data transfer has occurred
    recd_val = ser_port.read(); // Read byte from master
    ser_port.reply(switch_word); // Make this the next reply
 }
//now set leds according to received word.
     red_led=1; //preset both to off
     green_led=1;
     recd_val=recd_val&0x03; //AND out unwanted bits
     if (recd_val==1)
     {red_led=0; //red on, green off
      green_led=1;}
     if (recd_val==2)
     {red_led=1; //red off, green on
      green_led=0;}
     if (recd_val==3){
      red_led=0; //both on
      green_led=0;
   }
 }
}
