
#include "LM75B.h"
#include "MMA7660.h"
#include "MQTTEthernet.h"
#include "C12832.h"
#include "Arial12x12.h"
#include "rtos.h"


#if defined(TARGET_UBLOX_C027)
#warning "Compiling for mbed C027"
#include "C027.h"
#elif defined(TARGET_LPC1768)
#warning "Compiling for mbed LPC1768"
#include "LPC1768.h"
#elif defined(TARGET_K64F)
#warning "Compiling for mbed K64F"
#include "K64F.h"
#endif

/*--INITS-------------------------------------------------------------------------------*/
EthernetInterface eth;          //create ethernet
UDPSocket sock;                 //creat Ethernet socket
Endpoint server;                //create endpoint
InterruptIn joyclick(D4);           //joystick click as interrupt
AnalogIn pot1 (A0);             //left potentiometer

char* joystickPos = "CENTRE";
int blink_interval = 0;

/*--CONSTANTS---------------------------------------------------------------------------*/
const int PORT = 7;
static const char* SERVER_IP = "192.168.1.110"; //IP of server board
static const char* CLIENT_IP = "192.168.1.102"; //IP of client board
static const char* MASK = "255.255.255.0";      //mask
static const char* GATEWAY = "192.168.1.1";     //gateway

/*--VARIABLES---------------------------------------------------------------------------*/
int n;                  //size of received message
char in_buffer[1];      //create receive buffer
char counter[1] = {0};  //sample send buffer
int menuItem = 0;
int servertemp;             //temperature of the server device
float idealtemp;            //desired temperature
/*--FUNCTION DEFINITIONS----------------------------------------------------------------*/
/*****************************************************************************INIT_ETH***/
void init_eth(void)
{
    eth.init(CLIENT_IP, MASK, GATEWAY);                                         //set up IP
    eth.connect();                                                              //connect ethernet
    
    sock.init();                                                                //initialize socket
    
    server.set_address(SERVER_IP, PORT);                                        //set address of server
    
}   //end init_eth()
/******************************************************************************END_ETH***/
void end_eth(void)
{
    sock.close();       //close socket
    eth.disconnect();   //close Ethernet
    
}   //end end_eth()

/*****************************************************************************TEMP***/
void TEMP()
{
    counter[0] = (int)pot1*30;                                                                         
    sock.sendTo(server, counter, sizeof(counter));                                      //send message
    
    n = sock.receiveFrom(server, in_buffer, sizeof(in_buffer));                         //receive message from server
    in_buffer[n] = '\0';                                                                //add \0 to end of message
    servertemp = in_buffer[0];
}
/*****************************************************************************printMenu***/
void printMenu(int menuItem) 
{
    static char last_line1[30] = "", last_line2[30] = "";
    char line1[30] = "", line2[30] = "";
        
    switch (menuItem)
    {
        case 0:
            sprintf(line1, "Smart home system");
            sprintf(line2, "Scroll with joystick");
            break;
        case 1:
            sprintf(line1, "Use left dial to");
            sprintf(line2, "set ideal temperature");
            break;
        case 2:
            sprintf(line1, "Ideal temperature");
            sprintf(line2, "set to = %.0f", (float)pot1*30);
            break;
        case 3:
            sprintf(line1, "Temperature = %d", servertemp);
            if(servertemp <(float)pot1*30)
            sprintf(line2, "Heating ON");
            else
            sprintf(line2, "Heating OFF");
            break;

    }
    
    if (strcmp(line1, last_line1) != 0 || strcmp(line2, last_line2) != 0)
    {
        lcd.cls(); 
        lcd.locate(0, 0);
        lcd.printf(line1);
        strncpy(last_line1, line1, sizeof(last_line1));

        lcd.locate(0,16);
        lcd.printf(line2);
        strncpy(last_line2, line2, sizeof(last_line2));
    }
}

/*****************************************************************************setMenu***/
void setMenu()
{
    
    if (Down)
    {
        joystickPos = "DOWN";
        if (menuItem >= 0 && menuItem < 3)
            printMenu(++menuItem);
    } 
    else if (Left)
        joystickPos = "LEFT";
    else if (Click)
        joystickPos = "CLICK";
    else if (Up)
    {
        joystickPos = "UP";
        if (menuItem <= 3 && menuItem > 0)
            printMenu(--menuItem);
    }
    else if (Right)
        joystickPos = "RIGHT";
    else
        joystickPos = "CENTRE";
}

/*****************************************************************************menu_loop***/
void menu_loop(void const *args)
{
    int count = 0;
    while(true)
    {
        setMenu();
        if (++count % 10 == 0)
            printMenu(menuItem);
        Thread::wait(100);
    }
}


/**
 * Display a message on the LCD screen prefixed with IBM IoT Cloud
 */
void displayMessage(char* message)
{
    lcd.cls();
    lcd.locate(0,0);        
    lcd.printf("Welcome");
    lcd.locate(0,16);
    lcd.printf(message);
}



int main()
{    
    lcd.set_font((unsigned char*) Arial12x12);  // Set a nice font for the LCD screen
    
    led2 = LED2_OFF; // K64F: turn off the main board LED 
    
    Thread menu_thread(menu_loop);  
    

    
    
    int count = 0;
    while (true)
    {
        if (++count == 100)
        {               // Publish a message every second

        
        if (blink_interval == 0)
            led2 = LED2_OFF;
        else if (count % blink_interval == 0)
            led2 = !led2;
        
        TEMP();
        idealtemp=(float)pot1*30;
    }
    }
}
