#include "mbed.h"
#include <Pulse1.h>
#include "TextLCD.h"

TextLCD lcd(PTB10, PTB11, PTE2, PTE3, PTE4, PTE5);  //configura los puestos PTE0,PTE1,PTE2,PTE3,PTE4,PTE5, donde se conectara el LCD 16x2 
PulseInOut irda(PTD5);// en este puerto se pone el sensor infrarrojo
Serial pc(USBTX, USBRX);
DigitalOut led2_G(LED2);
DigitalOut led2_R(LED3);
DigitalOut led2_B(LED1);
int header =0; //tiempo de cabecera pulso abajo
const int head_H = 2430*1.2; //+20% medida con osciloscopio en microsegundos
const int head_L = 2430*0.8;//-20%  medida con osciloscopio
int i=0;
int n=0;
const int T_alto=1170;//ponga su tiempo de la prueba
const int T_bajo=567;//ponga su tiempo de la prueba
const int num_bits = 12;//ponga su numero de bits
int arreglo[num_bits];
int num[num_bits];//cadena para almacenar todos los tiempos que conforman los bits de datos
int dato; // tiempo de cada dato que se lee


int main(){
    lcd.cls();
while(1){
ini1: header=0;
          
      header = irda.read_low_us();    //funcion para leer un pulso de caida o bajo
         
      if (header > head_L && header < head_H) goto seguir;//verificar que este en la tolerancia +-20%
      else goto ini1;
      
seguir:
       //leo los datos de la trama y se meten a un arreglo
      lcd.locate(0,1);
      lcd.printf("            ");
      lcd.locate(0,1);      
      wait_us(1650/2);
      for(i=0;i<(num_bits);++i){ // POR OSCILOSCOPIO se determina que llegan (num_bits),datos
      dato = irda.read_low_us(); //leer un bit de datos que es pulso abajo en este control
      num[i]=dato;
      wait_us(550/2);   
      }
      wait(0.5); //espero un poquito antes de leer todo el arreglo y ponerlo en pantalla 
      for(i=0;i<(num_bits);++i){  
      if(num[i] > ((T_alto+T_bajo)/2)){ 
      arreglo[i]=1;
      lcd.printf("%d",arreglo[i]); 
      }
      else{
      arreglo[i]=0; 
      lcd.printf("%d",arreglo[i]); 
      }
      }
      lcd.locate(0,0);  
      lcd.printf("h=%dus",header);
      lcd.locate(8,0);
      lcd.printf("        ");
      lcd.locate(8,0);
      lcd.printf("T=%dus",dato); 
   }
 }