#include "mbed.h"              
#include "SDFileSystem.h"
#include "LPS331_SPI.h"
#include "ADXL345.h"
/*do include*/
DigitalOut myled(LED1);/*dp28 no LED*/
LPS331_SPI press(dp2, dp1, dp6, dp26);/*pressure no sengen*/
SDFileSystem sd(dp2, dp1, dp6, dp17, "sd"); /**/
AnalogIn sensor(dp4);
ADXL345 accelerometer(dp2,dp1,dp6,dp25);
Serial pc(USBTX,USBRX);
/*sengensuru*/

int main()
{
    int readings[3] = {0,0,0};
    accelerometer.setPowerControl(0x00);
    accelerometer.setDataFormatControl(0x0B);
    accelerometer.setDataRate(ADXL345_3200HZ);
    accelerometer.setPowerControl(0x08);
    
    
    press.quickStart();
    
    int cl;
    int pr;
    
    FILE *fp = fopen("/sd/sdtest.txt","a");
        if (fp == NULL) {
            printf("fopen error\n");
            
            }
    pr = fprintf(fp, "START");
        if (pr < 0){
            printf("fprintf error\n");
            }
            
    cl = fclose(fp);
    if(cl == EOF){
            printf("fclose error\n");
            }
            
    
    while(1){
        float ain = sensor;
        float pressure;
        accelerometer.getOutput(readings);
        pressure = press.getPressure();
        ain = (ain * 3.3 - 0.6) / 0.01;
        
        FILE *fp = fopen("/sd/sdtest.txt","a");
        if (fp == NULL) {
            printf("fopen error\n");
            
            }
            
        pr = fprintf(fp, "%f\r\n%f\r\n%i\r\n%i\r\n%i\r\n",pressure,ain,(int16_t)readings[0],(int16_t)readings[1],(int16_t)readings[2]);
        if (pr < 0){
            printf("fprintf error\n");
            
            }
        
        printf("%f\r\n%f\r\n%i\r\n%i\r\n%i\r\n",pressure,ain,(int16_t)readings[0],(int16_t)readings[1],(int16_t)readings[2]);
        
        cl = fclose(fp);
        if(cl == EOF){
            printf("fclose error\n");
            
            }
        
        free(fp);
        
        myled = !myled;
        wait(0.1);
        }
}
