/*
* HARDWARE:
* Board FRDM-K64F                        - https://os.mbed.com/platforms/FRDM-K64F/
* Display 4.3" 480 x 272 (RVT43ULFNWC03) - https://riverdi.com/product/rvt43ulfnwc0x/
* Break Out Board 20                     - https://riverdi.com/product/break-out-board-20/
* Cable FFC, 0.5mm pitch, 20 pin, 150 mm - https://riverdi.com/product/ffc0520150/
*
* WIRING:
* -----------------------------------
* FRDM-K64F           Break Out Board
* -----------------------------------
* +3.3V           --- Pin 1 VDD, Pin 17 BLVDD
* GND             --- Pin 2 GND      
* D13 (PTD1) SCLK --- Pin 3 SPI SCLK 
* D12 (PTD3) MISO --- Pin 4 MISO     
* D11 (PTD2) MOSI --- PIN 5 MOSI     
* D10 (PTD0)      --- Pin 6 CS       
* D9  (PTC4)      --- Pin 7 INT      
* D8  (PTC12)     --- Pin 8 PD       
* -----------------------------------
*
* SOFTWARE:
* Image2Bitmap.exe  -   https://github.com/FoxExe/Image2Bitmap
*/

#include "mbed.h"
#include "FT800.h"
#include "images.h"
/*
FT800 TFT(MOSI,MISO, SCK, CS, INT, PD);   */
FT800 TFT( D11, D12, D13, D10, D9, D8);   // FRDM-K64F

uint8_t i;
char    textbuff[32];

int main()
{   
    // for console
    //printf("Mbed OS %d.%d.%d.\n", MBED_MAJOR_VERSION, MBED_MINOR_VERSION, MBED_PATCH_VERSION);    
    sprintf(textbuff, "Mbed OS %d.%d.%d.", MBED_MAJOR_VERSION, MBED_MINOR_VERSION, MBED_PATCH_VERSION);
     
    TFT.Init();
    
    // Draw Logo
    TFT.DLstart();      // start Display Liste
    TFT.drawLogo();     // start Logo
    TFT.waitLogo();     // wait
    TFT.DLend();        // end Display Liste
    thread_sleep_for(3000);
    
    // Draw Background color red
    TFT.DLstart(RED);
    TFT.drawText(240,135, 29, BLACK, OPT_CENTER, textbuff);
    TFT.DLend();
    thread_sleep_for(3000);
    
    // Draw Background color green
    TFT.DLstart(GREEN);
    TFT.DLend();
    thread_sleep_for(3000);
    
    // Draw Background color blue
    TFT.DLstart(BLUE);
    TFT.DLend();
    thread_sleep_for(3000);
        
    // -------------------------------------------------------------------------
    // https://www.ftdichip.com/Support/Documents/DataSheets/ICs/DS_FT800.pdf
    TFT.DLstart(BLACK);
    TFT.beginBitmap();    
 
    // Draw ASCII Characters number 0 - 127, Font 18
    for (i = 0;  i <= 32; i++) { TFT.Vertex2II(  i*10,     0, 18, i); }
    for (i = 33; i <= 64; i++) { TFT.Vertex2II((i-33)*10, 20, 18, i); }
    for (i = 65; i <= 96; i++) { TFT.Vertex2II((i-65)*10, 40, 18, i); }
    for (i = 98; i < 128; i++) { TFT.Vertex2II((i-98)*10, 60, 18, i); }
    
    // Draw Characters number 0 - 127, Font 19
    TFT.setColor(GREEN);
    for (i = 0;  i <= 32; i++) { TFT.Vertex2II(  i*10,   120, 19, i); }
    for (i = 33; i <= 64; i++) { TFT.Vertex2II((i-33)*10,140, 19, i); }
    for (i = 65; i <= 96; i++) { TFT.Vertex2II((i-65)*10,160, 19, i); }
    for (i = 98; i < 128; i++) { TFT.Vertex2II((i-98)*10,180, 19, i); }
    
    TFT.DLend();
    thread_sleep_for(5000);
        
    // -------------------------------------------------------------------------
    // Pattern for Background. 
    static const uint8_t pict[] = {0x77,0xE2,0xC1,0xA3,0x77,0x3A,0x1C,0x2E};
    TFT.writeRAMG(0, pict, 8);     // Writing a picture 8x8 pixels to RAM_G    
    TFT.DLstart(BLACK);                             // 0х77 = 0b01110111 = ▓...▓...
    TFT.bitmapSource(0);                            // 0xE2 = 0b11100010 = ...▓▓▓.▓
    TFT.bitmapLayout(L1, 1, 8);                     // 0xC1 = 0b11000001 = ..▓▓▓▓▓.
    TFT.bitmapSize(NEAREST,REPEAT,REPEAT,480,272);  // 0xA3 = 0b10100011 = .▓.▓▓▓..
    TFT.beginBitmap();                              // 0x77 = 0b01110111 = ▓...▓...
    TFT.Vertex2II(0,0, 0,0);                        // 0x3A = 0b00111010 = ▓▓...▓.▓
    TFT.DLend();                                    // 0x1C = 0b00011100 = ▓▓▓...▓▓
    thread_sleep_for(5000);                         // 0x2E = 0b00101110 = ▓▓.▓...▓
    
    // -------------------------------------------------------------------------
    // GRADIENT SPECTRUM for Background
    TFT.writeRAMG16(0, spectrum, 384); // Writing a spektrum[] to RAM_G
    TFT.DLstart(BLACK);
    TFT.bitmapSource(0);
    TFT.bitmapLayout(RGB565, 768, 1);
    TFT.bitmapSize(NEAREST,BORDER,REPEAT,384,272);
    TFT.beginBitmap();
    TFT.Vertex2II(0,0, 0,0);
    TFT.DLend();
    thread_sleep_for(5000);
    
    // -------------------------------------------------------------------------
    // The Image «butterfly», Size 100x80 pixels, data typ uint16_t
    // Format RGB565 (2 Bytes per pixel)
    TFT.writeRAMG16(0, butterfly, 8000);
    TFT.DLstart(WHITE);
    TFT.bitmapSource(0);
    TFT.bitmapLayout(RGB565, 200, 80); 
    TFT.bitmapSize(NEAREST,BORDER,BORDER,100,80);
    TFT.beginBitmap();
    TFT.Vertex2II(190,100, 0,0);
    TFT.DLend();
    thread_sleep_for(5000);    
    
    // -------------------------------------------------------------------------
    // The Image «Che Guevara», Size 480x272 pixels and consists of 2 parts (image1 & image2)
    // Format RGB332 (1 Byte per pixel: RRRGGGBB, 256 colors)
    TFT.writeRAMG(    0, CheGuevara1, 65280);
    TFT.writeRAMG(65280, CheGuevara2, 65280);
    
    TFT.DLstart(BLACK);
    TFT.bitmapSource(0);
    TFT.bitmapLayout(RGB332, 480, 272);
    TFT.bitmapSize(NEAREST,BORDER,BORDER,480,272);
    TFT.beginBitmap();
    TFT.Vertex2II(0,0, 0,0);
    TFT.DLend();
    
    return 0;
}