/* mbed Library for FTDI FT800 */
 
#ifndef FT800_FUNCTIONS_H
#define FT800_FUNCTIONS_H

class FT800
{
public:
    FT800(PinName mosi,
          PinName miso,
          PinName sck,
          PinName ss,
          PinName intr,
          PinName pd);
private:
    SPI _spi;
    DigitalOut  _ss;
    DigitalOut  _pd;
    InterruptIn _f800_isr;

public:
    uint16_t    CMD_Offset = 0;
    //-----------------------------CMD Offset----------------------------------------
    void        CMD_Offset_Inc(uint8_t command_size);
    void        set_CMD_Offset(uint16_t offset);
    uint16_t    get_CMD_Offset(void);
    //-------------------------------WRITE-------------------------------------------
    void        WriteAddress(uint32_t addr, uint8_t mode);
    void        Write08(uint32_t addr, uint8_t data);
    void        Write16(uint32_t addr, uint16_t data);
    void        Write32(uint32_t addr, uint32_t data);
    //--------------------------------READ-------------------------------------------
    uint8_t     Read08(uint32_t addr);
    uint16_t    Read16(uint32_t addr);
    uint32_t    Read32(uint32_t addr);
    //----------------------------CONFIGURATION--------------------------------------
    void        HostCommand(uint8_t cmd);
    //----------------------------MEMORY RAM_G---------------------------------------
    void  writeMemZero(uint32_t ptr, uint32_t numb);
    void  writeMemSet(uint32_t ptr, uint32_t value, uint32_t numb);
    void  writeMemCpy(uint32_t dest, uint32_t source, uint32_t numb);
    void  writeMemWrt(uint32_t ptr, uint32_t numb);
    //--------------------------------INIT-------------------------------------------
    void  Init();
    void  Sleep(uint16_t ms);
    void  setBacklight(uint8_t brightnes);
    void  setGPU_Frequency(uint8_t freq);   // 36=GPU_PLL_36M, 48=GPU_PLL_48M MHz
    void  clearIntFlags(void);
    
    void  DLstart(void);
    void  DLstart(uint32_t color);
    void  DLstart(uint32_t color, uint8_t br);
    void  DLend(void);
    void  clear(uint8_t clr);
    void  finishList(void);
    //void  executeCommands(void);
    //-----------------------------GRAPHICS STATE------------------------------------
    void  setColor(uint32_t color);             // color 0xRRGGBB, default White (0xFFFFFF)
    void  setColorA(uint8_t alpha);             // alpha [0-255], default 255, transparency off
    void  setClearColor(uint32_t color);        // color 0xRRGGBB, default Black (0x000000)
    void  setClearColorA(uint8_t alpha);        // alpha [0-255], default 0
    void  setLineWidth(uint16_t width);         // width [1-255], default 1
    void  setPointSize(uint16_t size);          // size  [1-512], default 1
    void  setScissorSize(uint16_t width, uint16_t height);  // w & h [0-512], default (512,512)
    void  setScissorXY(int16_t x, int16_t y);   // x & y [-512-+511], default (0,0)
    void  setBlendFunc(uint8_t src, uint8_t dst);// src & dst [0-7]
    void  align(uint8_t n);
    //----------------------CO-PROCESSOR ENGINE GRAPHICS STATE-----------------------
    void  setFgColor(uint32_t color);           // Foreground, default light blue (0x003870)
    void  setBgColor(uint32_t color);           // Background, default dark blue (0x002040)
    void  setGrColor(uint32_t color);           // Gradient, default white (0xFFFFFF)    
    //---------------------------DRAWING BASE FUNCTIONS------------------------------
    void  beginBitmap();        void  drawBitmapXY(int16_t x, int16_t y);
    void  beginPoint();         void  drawPointXY(int16_t x, int16_t y);
    void  beginLine();          void  drawLineXY(int16_t x1, int16_t y1, int16_t x2, int16_t y2);
    void  beginRect();
    void  beginLineStrip();
    void  Vertex2F(int16_t x, int16_t y);   // x & y [-1024-+1023]
    void  Vertex2II(uint16_t x, uint16_t y, uint8_t handle, uint8_t cell); // x & y [0-511]
    void  end();            // End drawing a graphics primitive.
    //------------------------DRAWING GRAPHICS PRIMITIVE-----------------------------
    void  drawPoint(int16_t x, int16_t y, uint32_t color, uint16_t radius);
    void  drawLine(int16_t x1, int16_t y1, int16_t x2, int16_t y2, uint32_t color, uint16_t width);
    void  drawRect(int16_t x1, int16_t y1, int16_t x2, int16_t y2, uint32_t color, uint16_t width);
    void  drawLineStrips(int16_t x[], int16_t y[], uint16_t num_of_points, uint16_t width, uint32_t color);
    void  drawEdgeStrips(int16_t x[], int16_t y[], uint16_t num_of_points, uint8_t choice, uint32_t color);
    //---------------------------------DRAW TEXT-------------------------------------
    void  drawChar(uint16_t x, uint16_t y, uint8_t font, uint32_t color, char c);
    void  drawString(const char *s);
    void  drawText  (int16_t x, int16_t y, uint8_t font, uint32_t color, uint16_t option, const char *s);
    void  drawNumber(int16_t x, int16_t y, uint8_t font, uint32_t color, uint16_t option, uint32_t n);
    //----------------------------DRAW GRAPHICS OBJECTS------------------------------
    void  drawButton(int16_t x, int16_t y, uint16_t w, uint16_t h, uint16_t option, uint32_t colorBG, uint32_t colorTXT, uint8_t font, const char*s, uint8_t tag);
    void  drawClock(int16_t x, int16_t y, uint16_t r, uint16_t option, uint32_t colorBG,   uint32_t colorNeedle, uint16_t h, uint16_t m, uint16_t s, uint16_t ms, uint8_t tag);
    void  drawDial (int16_t x, int16_t y, uint16_t r, uint16_t option, uint32_t colorMarker, uint32_t colorKnob, uint16_t value,  uint8_t tag);
    void  drawGauge(int16_t x, int16_t y, uint16_t r, uint16_t option, uint32_t colorBCG,  uint32_t colorNeedle, uint8_t major, uint8_t minor, uint16_t value, uint16_t range, uint8_t tag);
    void  drawGradient(int16_t x0, int16_t y0, uint32_t color0, int16_t x1, int16_t y1, uint32_t color1);
    void  drawKeys(int16_t x, int16_t y, uint16_t w, uint16_t h, uint16_t option, uint32_t colorBG, uint32_t colorTXT, uint8_t font, const char *s, uint8_t tag);
    void  drawScrollBar(int16_t x, int16_t y, uint16_t w, uint16_t h, uint32_t colorBG, uint32_t colorSCR, uint16_t option, uint16_t value, uint16_t size, uint16_t range, uint8_t tag);
    void  drawToggle(int16_t x, int16_t y, uint16_t w, uint8_t font, uint16_t option, uint32_t colorKnob, uint32_t colorBCG, uint32_t colorTXT, uint16_t state, const char *s, uint8_t tag);
    void  drawSlider(int16_t x, int16_t y, uint16_t w, uint16_t h,   uint16_t option, uint32_t colorR,  uint32_t colorKnob,  uint32_t colorL,  uint16_t value, uint16_t range, uint8_t tag);
    void  drawProgress(int16_t x, int16_t y, uint16_t w, uint16_t h, uint16_t option, uint32_t colorBCG, uint32_t colorPRO,  uint16_t value, uint16_t range, uint8_t tag);
    //----------------------------------TAG------------------------------------------
    void  track(int16_t x, int16_t y, uint16_t w, uint16_t h, uint8_t tag);
    void  tagMask(uint8_t mask);
    uint8_t readTag(void);
    uint16_t readValue(void);
    //----------------------------------ANIM-----------------------------------------
    void  runTouchCalibration(void);
    void  drawAnimSpinner(int16_t x, int16_t y, uint8_t style, uint8_t scale);
    void  drawLogo(void);
    void  waitLogo(void);
    void  drawScreensaver(void);
    void  drawSketch(int16_t x, int16_t y, uint16_t w, uint16_t h, uint32_t pointer, uint16_t format);
    void  macro(uint8_t m);
    void  stop(void);
    //---------------------------------BITMAP----------------------------------------
    void  bitmapHandle(uint8_t handle);     // default 0
    void  bitmapSource(uint32_t add);       //
    void  bitmapLayout(uint8_t format, int16_t linestride, int16_t heigth);
    void  bitmapSize(uint8_t filter, uint8_t wrapx, uint8_t wrapy, int16_t width, int16_t heigth);
    void  bitmapTransformA(int32_t value);
    void  bitmapTransformB(int32_t value);
    void  bitmapTransformC(int32_t value);
    void  bitmapTransformD(int32_t value);
    void  bitmapTransformE(int32_t value);
    void  bitmapTransformF(int32_t value);
    void  loadIdentity(void);
    void  setMatrix(void);
    void  scale(int16_t sx, int16_t sy);
    void  translate(int16_t tx, int16_t ty);
    void  rotate(int16_t a);
    void  inflate(uint32_t ptr);
    void  loadJpgCMD(uint32_t ptr, uint32_t opt);
    //---------------------------------TEST------------------------------------------
    void  writeRAMG  (uint32_t addr, const uint8_t  data[], uint32_t lng);    
    void  writeRAMG16(uint32_t addr, const uint16_t data[], uint16_t lng);
    void  drawChar16(int16_t x, int16_t y, const uint16_t font[], uint16_t n);
    void  drawChar16(int16_t x, int16_t y, uint32_t color, int16_t scl, uint16_t n);
};  // end of class

#endif  /* FT800_FUNCTIONS_H */