/* mbed Library for FTDI FT800 */
 
#ifndef FT800_DISPLAY_H
#define FT800_DISPLAY_H

#define GPU_FREQ            48000000ULL     // FT800 frequency 
#define DISP_FPS            60              // frame rate

//------------------------------------------------------------------------------
//DISPLAY TIMING         480 x 272   320 x 240
//------------------------------------------------------------------------------
#define DISP_WIDTH          480     // 320  // Horizontal Size
#define DISP_HSYNC0         0       // 0    // Start of HSYNC (falling edge)
#define DISP_HSYNC1         41      // 10   // End of HSYNC (rising edge)
#define DISP_HFP            25
#define DISP_HSLEN          2

#define DISP_HEIGHT         272     // 240  // Vertical Size
#define DISP_VSYNC0         0       // 0    // Start of VSYNC (falling edge)
#define DISP_VSYNC1         10      // 2    // End of VSYNC (rising edge)
#define DISP_VFP            8
#define DISP_VSLEN          2

#define DISP_PCLK_POL       1       // 0    // Pixel Clock Polarity
#define DISP_SWIZZLE        0               // B[7:2] G[7:2] R[7:2] - arrangement of output RGB pins

#define DISP_HCYCLE         548     // 408  // (DISP_WIDTH + DISP_HSYNC1 + DISP_HFP + DISP_HSLEN) Total number of clocks per line
#define DISP_VCYCLE         292     // 263  // (DISP_HEIGHT+ DISP_VSYNC1 + DISP_VFP + DISP_VSLEN) Total number of lines per screen
#define DISP_PCLK           5       // 8    // (GPU_FREQ / DISP_VCYCLE / DISP_HCYCLE /(DISP_FPS-1)) Set Pixel Clock Frequenc

#define DISP_PWM_HZ         250     // 250  // Set backlight PWM frequency in Hz
#define DISP_PWM_DUTY       128     // 128  // Set backlight duty cycle (brightness), 0 = off, 0x80 = full brightness

//------------------------------------------------------------------------------
//TOUCH SCREEN
//------------------------------------------------------------------------------
#define TOUCH_SENSITIVITY   1500    // 0x0000-0xFFFF (highest sensitivity)
#define TOUCH_MODE          3       // 0-off, 1- single mode, 2-frame mode, 3-continuous mode 
#define TOUCH_ADC_MODE      1       // 0-Single Ended mode,  1-Differential Mode
#define TOUCH_CHARGE        6000    // touch-screen charge time, in the unit of 6 clocks
#define TOUCH_SETTLE        3       // touch screen settle time in the unit of 6 clocks
#define TOUCH_OVERSAMPLE    7       // 1-15, touch screen oversample factor. The higher value -> more accuracy & more power consumption 

//------------------------------------------------------------------------------
//GPIO PINS
//------------------------------------------------------------------------------
#define GPIO_DIR            0x80    // GPIO7-GPIO0, 1=output, 0=input
#define GPIO_SET            0x80    // GPIO7-GPIO0, 1="HI", 0="LO"

#endif