#include "mbed.h"
#include "lib.h"
#include <cstring>

#define CMD_ENROLL  0x01
#define CMD_AUTH    0x02
#define FACE_FID    0x01
#define SPEECH_FID  0x02
#define VOICE_FID   0x03
#define SUCCESS     0x55
#define FAILURE     0x8A

int hashcode(const char *data, int size)
{
    int hash = 17;
    for (int i = 0; i < size; i++) {
        hash += 31*hash + data[i];
    }
    return hash;
}
void read_mag_card(Serial *device, char *dest, int *size)
{
    int pos = 0;
    bool done = false;
    int markercount = 0;
    while (!done) {
        while (!device->readable());
        dest[pos] = device->getc();
        if (dest[pos] == '?') markercount++;
        if (markercount >= 2) done  = true;
        pos++;
    }
    *size = pos - 1;
}

bool fp_enroll(FPScanner *fp)
{
    bool status = true;
    fp->SetLED(true);
    while(!fp->IsPressFinger()) wait(0.030);
    fp->CaptureFinger(true);
    if (fp->Identify1_N() == 200) {
        int id = fp->GetEnrollCount();
        if (fp->EnrollStart(id) == 0) {
            fp->CaptureFinger(true);
            fp->Enroll1();
            fp->CaptureFinger(true);
            fp->Enroll2();
            fp->CaptureFinger(true);
            fp->Enroll3();
            fp->SetLED(false);
        } else status = false;
    } else status = false;

    return status;
}

bool fp_auth(FPScanner *fp)
{
    bool status = false;
    fp->SetLED(true);
    while(!fp->IsPressFinger()) wait(0.030);
    fp->CaptureFinger(true);
    if (fp->Identify1_N() != 200) status = true;
    fp->SetLED(false);
    return status;
}

bool face_enroll(char *user_id, Serial *android)
{
    char CMD[] = {
        0x0A,
        CMD_ENROLL,
        0x02,
        0x04,
        0x01,
        user_id[0],
        user_id[1],
        user_id[2],
        user_id[3],
        FACE_FID,
        '\0'
    };

    for (int i = 0; i < sizeof(CMD)/ sizeof(char); i++) {
        while(!android->writeable());
        android->putc(CMD[i]);
    }

    while (!android->readable());
    char temp = android->getc();
    if (temp == SUCCESS) return true;
    else return false;
}

bool face_auth(char *user_id, Serial *android)
{
    char CMD[] = {
        0x0A,
        CMD_AUTH,
        0x02,
        0x04,
        0x01,
        user_id[0],
        user_id[1],
        user_id[2],
        user_id[3],
        FACE_FID,
        '\0'
    };

    for (int i = 0; i < sizeof(CMD)/ sizeof(char); i++) {
        while(!android->writeable());
        android->putc(CMD[i]);
    }

    while (!android->readable());
    char temp = android->getc();
    if (temp == SUCCESS) return true;
    else return false;
}

bool speech_enroll(char *user_id, Serial *android)
{
    char CMD[] = {
        0x0A,
        CMD_ENROLL,
        0x02,
        0x04,
        0x01,
        user_id[0],
        user_id[1],
        user_id[2],
        user_id[3],
        SPEECH_FID,
        '\0'
    };

    for (int i = 0; i < sizeof(CMD)/ sizeof(char); i++) {
        while(!android->writeable());
        android->putc(CMD[i]);
    }

    while (!android->readable());
    char temp = android->getc();
    if (temp == SUCCESS) return true;
    else return false;
}

bool speech_auth(char *user_id, Serial *android)
{
    char CMD[] = {
        0x0A,
        CMD_AUTH,
        0x02,
        0x04,
        0x01,
        user_id[0],
        user_id[1],
        user_id[2],
        user_id[3],
        SPEECH_FID,
        '\0'
    };

    for (int i = 0; i < sizeof(CMD)/ sizeof(char); i++) {
        while(!android->writeable());
        android->putc(CMD[i]);
    }

    while (!android->readable());
    char temp = android->getc();
    if (temp == SUCCESS) return true;
    else return false;
}

bool voice_enroll(char *user_id, Serial *android)
{
    char CMD[] = {
        0x0A,
        CMD_ENROLL,
        0x02,
        0x04,
        0x01,
        user_id[0],
        user_id[1],
        user_id[2],
        user_id[3],
        VOICE_FID,
        '\0'
    };

    for (int i = 0; i < sizeof(CMD)/ sizeof(char); i++) {
        while(!android->writeable());
        android->putc(CMD[i]);
    }

    while (!android->readable());
    char temp = android->getc();
    if (temp == SUCCESS) return true;
    else return false;
}

bool voice_auth(char *user_id, Serial *android)
{
    char CMD[] = {
        0x0A,
        CMD_AUTH,
        0x02,
        0x04,
        0x01,
        user_id[0],
        user_id[1],
        user_id[2],
        user_id[3],
        VOICE_FID,
        '\0'
    };

    for (int i = 0; i < sizeof(CMD)/ sizeof(char); i++) {
        while(!android->writeable());
        android->putc(CMD[i]);
    }

    while (!android->readable());
    char temp = android->getc();
    if (temp == SUCCESS) return true;
    else return false;
}

void buzzer(PwmOut *speaker, int seconds)
{
    speaker->period(1.0/500.0);
    *speaker = 0.5;
    wait(seconds);
    *speaker = 0.0;
}

void display_msg(Cryst_LCD *lcd, char *text)
{
    lcd->cls();
    lcd->locate(1, 0);
    lcd->printf("%s", text);
}

void greeting(Cryst_LCD *lcd)
{
    lcd->cls();
    lcd->locate(0, 7);
    lcd->printf("WELCOME");
    lcd->locate(3, 0);
    lcd->printf("*:AUTH");
    lcd->locate(3, 12);
    lcd->printf("#:ENROLL");
}

bool prompt(const char* msg, Cryst_LCD *lcd, Keypad<4, 3>* pad)
{
    bool res = false;
    char temp;
    lcd->cls();
    lcd->locate(0,0);
    lcd->printf("%s", msg);
    lcd->locate(3, 0);
    lcd->printf("*:NO");
    lcd->locate(3, 15);
    lcd->printf("#:YES");
    while ((temp = pad->getKeyChar()) != '#' && temp != '*');
    if (temp == '#') res = true;
    return res;
}

bool is_valid_user(char *user_id)
{
    char full_path[30];
    std::strcpy(full_path, "/local/");
    char filename[10];
    std::memcpy(filename, user_id, 4);
    filename[4] = '\0';
    std::strcat(filename, ".TXT");
    std::strcat(full_path, filename);
    FILE *fp = fopen(full_path, "r");
    if (fp == NULL)return false;
    else fclose(fp);
    return true;
}

bool write_hash_to_file(char *user_id, int hash)
{
    char full_path[30];
    std::strcpy(full_path, "/local/");
    char filename[10];
    std::memcpy(filename, user_id, 4);
    filename[4] = '\0';
    std::strcat(filename, ".TXT");
    std::strcat(full_path, filename);
    FILE *fp = fopen(full_path, "w");
    if (fp == NULL) return false;
    fprintf(fp, "%d", hash);
    fclose(fp);
    return true;
}

bool read_hash_from_file(char *user_id, int *hash)
{
    bool success_read = false;
    char full_path[30];
    std::strcpy(full_path, "/local/");
    char filename[10];
    std::memcpy(filename, user_id, 4);
    filename[4] = '\0';
    std::strcat(filename, ".TXT");
    std::strcat(full_path, filename);
    FILE *fp = fopen(full_path, "r");
    if (fp) {
        int t = fscanf(fp, "%d", hash);
        if (t != 0 && t != EOF) success_read = true;
        fclose(fp);
    }
    return success_read;
}

bool read_pin(char *buffer, int length, Cryst_LCD* lcd, Keypad<4, 3>* pad)
{
    bool res = false;
    int cur = 0;
    lcd->cls();
    lcd->locate(3,0);
    lcd->printf("*:CLEAR");
    lcd->locate(3, 13);
    lcd->printf("#:ENTER");
    lcd->locate(0,0);
    lcd->printf("Enter 4-Digit PIN:\n");
    lcd->cursor_on();
    lcd->cursor_blink();
    bool done  = false;
    char temp_char;
    while (!done) {
        temp_char = pad->getKeyChar();
        if (temp_char == '#') done = true;
        else if (temp_char == '*') {
            lcd->clear_line();
            cur = 0;
        } else {
            if (cur < 19) lcd->printf("%C", '*');
            if (cur < length) buffer[cur] = temp_char;
            cur++;
        }
    }
    if (cur == length) res = true;
    lcd->cursor_off();
    lcd->cursor_no_blink();
    return res;
}


bool fp_clearAll(FPScanner *fp)
{
    bool status;
    fp->SetLED(true);
    status = fp->DeleteAll();
    fp->SetLED(false);
    return status;
}

char clear_serial_buffer(Serial *dev)
{
    char temp;
    while (dev->readable()) {
        temp = dev->getc();
    }
    return temp;
}
