#include "mbed.h"
#include "keypad.h"
#include "cryst_lcd.h"
#include "FPScanner.h"
#include "lib.h"
#include <cstring>

Serial mag_card(p9, p10);
Serial android(USBTX, USBRX);
FPScanner fp(p28, p27);
Cryst_LCD lcd(p20, p19, p18, p17, p16, p15, Cryst_LCD::LCD20x4);
PwmOut speaker(p21);
//Create the keypad ky values
char mat[][3] = {{'1', '2', '3'}, {'4', '5', '6'}, {'7', '8', '9'}, {'*', '0', '#'}};
// Create the bus for use with the keypad's columns
BusInOut colPins(p24, p22, p26); // increasing order (column 1 ....n)
// Create the bus for use with the keypad's rows
BusInOut rowPins(p23, p30, p29, p25); // increasing order (row 1 ....n)
// Create the keypad object
Keypad<4, 3> pad(mat, &rowPins, &colPins);
LocalFileSystem local_fs("local");
DigitalOut door_lock(p8);
DigitalIn sys_reset(p14);

enum STATE {STANDBY, ENROLL, AUTH, FP_ENROLL, FP_AUTH, MC_ENROLL, MC_AUTH, FACE_ENROLL, FACE_AUTH, SPEECH_ENROLL, SPEECH_AUTH,
            ENROLL_SUCCESS, AUTH_SUCCESS, VOICE_ENROLL, VOICE_AUTH
           };

char user_id[4];
char mag_card_data[250];
char keyboard_input[20];
int mc_bytes = 0;
char temp_char;
int temp_int;
bool flag;

int main()
{
    sys_reset.mode(PullUp);
    if (sys_reset == 0) fp_clearAll(&fp);
    speaker.period(1.0/440);
    door_lock = 0;
    STATE current_state = STANDBY;
    while (true) {
        switch (current_state) {
            case STANDBY: {
                clear_serial_buffer(&android);
                greeting(&lcd);
                temp_char = pad.getKeyChar();
                while (temp_char != '#' && temp_char !=  '*') {
                    temp_char = pad.getKeyChar();
                }
                if (temp_char == '*') current_state = AUTH;
                else current_state = ENROLL;
                break;
            }
            case ENROLL: {
                if (read_pin(user_id, 4, &lcd, &pad)) {
                    if (is_valid_user(user_id)) {
                        display_msg(&lcd, "USER ALREADY\nENROLLED.");
                        wait(3);
                        current_state = STANDBY;
                    } else current_state = FACE_ENROLL;
                } else {
                    display_msg(&lcd, "INVALID PIN.");
                    wait(3);
                    current_state = STANDBY;
                }
                break;
            }
            case FP_ENROLL: {
                display_msg(&lcd, "PLACE YOUR FINGER\nON SCANNER.");
                if (fp_enroll(&fp)) {
                    current_state = MC_ENROLL;
                } else {
                    display_msg(&lcd, "FINGERPRINT FAILED.");
                    wait(3);
                    current_state = STANDBY;
                }
                break;
            }
            case MC_ENROLL: {
                flag = false;
                while (!flag) {
                    display_msg(&lcd, "SWIPE CARD NOW");
                    read_mag_card(&mag_card, mag_card_data, &mc_bytes);
                    if (prompt("SUCCESSFUL SWIPE?", &lcd, &pad)) flag = true;
                }
                temp_int = hashcode(mag_card_data, mc_bytes);
                if (write_hash_to_file(user_id, temp_int)) current_state = ENROLL_SUCCESS;
                else {
                    display_msg(&lcd, "AN ERROR OCCURED.");
                    wait(3);
                    current_state = STANDBY;
                }
                break;
            }
            case FACE_ENROLL: {
                display_msg(&lcd, "PROCEED TO\nFACE ENROLLMENT.");
                wait(2);
                if (face_enroll(user_id, &android)) {
                    current_state = SPEECH_ENROLL;
                } else {
                    display_msg(&lcd, "FACE ENROLLMENT\nFAILED.");
                    wait(3);
                    current_state = STANDBY;
                }
                break;
            }
            case SPEECH_ENROLL: {
                display_msg(&lcd, "PROCEED TO\nSPEECH ENROLLMENT.");
                wait(2);
                if (speech_enroll(user_id, &android)) {
                    current_state = FP_ENROLL;
                } else {
                    display_msg(&lcd, "SPEECH ENROLLMENT\nFAILED.");
                    wait(3);
                    current_state = STANDBY;
                }
                break;
            }
            //case VOICE_ENROLL: {
//                display_msg(&lcd, "PROCEED TO\nVOICE ENROLLMENT.");
//                wait(3);
//                if (voice_enroll(user_id, &android)) {
//                    current_state = FP_ENROLL;
//                } else {
//                    display_msg(&lcd, "VOICE ENROLLMENT\nFAILED.");
//                    wait(3);
//                    current_state = STANDBY;
//                }
//                break;
//            }
            case ENROLL_SUCCESS: {
                display_msg(&lcd, "ENROLLMENT\nSUCCESSFUL.");
                wait(3);
                current_state = STANDBY;
                break;
            }
            case AUTH: {
                if (read_pin(user_id, 4, &lcd, &pad) && is_valid_user(user_id)) {
                    current_state = MC_AUTH;
                } else {
                    display_msg(&lcd, "INVALID PIN.");
                    wait(3);
                    current_state = STANDBY;
                }
                break;
            }
            //case FP_AUTH: {
//                display_msg(&lcd, "PLACE YOUR FINGER\nON SCANNER.");
//                if (fp_auth(&fp)) {
//                    current_state = MC_AUTH;
//                } else {
//                    display_msg(&lcd, "FINGERPRINT FAILED.");
//                    wait(3);
//                    current_state = STANDBY;
//                }
//                break;
//            }
            case MC_AUTH: {
                flag = false;
                while (!flag) {
                    display_msg(&lcd, "SWIPE CARD NOW");
                    read_mag_card(&mag_card, mag_card_data, &mc_bytes);
                    if (prompt("SUCCESSFUL SWIPE?", &lcd, &pad)) flag = true;
                }
                temp_int = hashcode(mag_card_data, mc_bytes);
                int saved_hash = 0;
                if (read_hash_from_file(user_id, &saved_hash) && temp_int == saved_hash) {
                    current_state = FACE_AUTH;
                } else {
                    display_msg(&lcd, "AUTH FAILED.");
                    wait(3);
                    current_state = STANDBY;
                }
                break;
            }
            case FACE_AUTH: {
                display_msg(&lcd, "PROCEED TO FACE\nAUTHENTICATION.");
                wait(2);
                if (face_auth(user_id, &android)) {
                    current_state = SPEECH_AUTH;
                } else {
                    display_msg(&lcd, "FACE AUTH FAILED.");
                    wait(3);
                    current_state = STANDBY;
                }
                break;
            }
            case SPEECH_AUTH: {
                display_msg(&lcd, "PROCEED TO SPEECH\nAUTHENTICATION.");
                wait(2);
                if (speech_auth(user_id, &android)) {
                    current_state = AUTH_SUCCESS;
                } else {
                    display_msg(&lcd, "SPEECH AUTH FAILED.");
                    wait(3);
                    current_state = STANDBY;
                }
                break;
            }
            //case VOICE_AUTH: {
//                display_msg(&lcd, "PROCEED TO VOICE\nAUTHENTICATION.");
//                wait(2);
//                if (voice_auth(user_id, &android)) {
//                    current_state = AUTH_SUCCESS;
//                } else {
//                    display_msg(&lcd, "VOICE AUTH FAILED.");
//                    wait(3);
//                    current_state = STANDBY;
//                }
//                break;
//            }
            case AUTH_SUCCESS: {
                speaker = 0.5;
                door_lock = 1;
                display_msg(&lcd, "ACCESS GRANTED!");
                wait(3);
                door_lock = 0;
                speaker = 0;
                current_state = STANDBY;
            }
        }
    }
}
