/** 
 * This example shows how the ESP8266 chip can work hand-in-hand with the mbed
 * to effectively set up a dynamic web server.
 * This example, however, does not implement a fully functional web server. 
 * Instead, it just shows how to set up a serial link between the mbed and ESP module
 * so that at every page request, the mbed provides the content to respond with.
 * to extend on this example, one would need to be familiar with NodeMCU and LUA programming.
 *
 * Some links:
 * http://frederickvandenbosch.be/?p=1629
 * https://www.lua.org/pil/contents.html
 * https://nodemcu.readthedocs.io/en/master/en/modules/uart/
 * https://nodemcu.readthedocs.io/en/master/#nodemcu-documentation
 */

#include "mbed.h"

Serial pc(USBTX, USBRX);
Serial esp(p28, p27);
DigitalOut reset(p26);
Timer t;
char rx_buf[2048];
volatile int index = 0;
volatile int id = 48;

void get_reply(int timeout);
void esp_handler(void);

char SSID[] = "net-name";
char pswd[] = "net-password";

int main()
{
    pc.baud(9600);
    pc.printf("[mbed]\t: Resetting ESP device ... \n\r");
    reset = 0;
    wait(0.5);
    reset = 1;
    esp.baud(9600);
    get_reply(10);

    pc.printf("\n\r[mbed]\t: Connecting to Wi-Fi network ... \n\r");
    esp.printf("global_c = nil \n\r"); get_reply(3); pc.printf("[esp]\t: %s \n\r", rx_buf);
    esp.printf("wifi.setmode(wifi.STATION) \n\r"); get_reply(7); pc.printf("[esp]\t: %s \n\r", rx_buf);
    esp.printf("wifi.sta.config(\"%s\", \"d%s\") \n\r", SSID, pswd); get_reply(7); pc.printf("[esp]\t: %s \n\r", rx_buf);
    esp.printf("tmr.delay(1000000) \n\r"); get_reply(3); pc.printf("[esp]\t: %s \n\r", rx_buf);
    esp.printf("print(\"IP addr = \" .. wifi.sta.getip()) \n\r"); get_reply(15);
    pc.printf("[esp]\t: %s \n\r", rx_buf);

    pc.printf("\n\r[mbed]\t: Setting server up .. \n\r");
    esp.printf("srv = net.createServer(net.TCP) \n\r"); get_reply(10); pc.printf("[esp]\t: %s \n\r", rx_buf);
    esp.printf("srv:listen(80, function(c) \n\r"); get_reply(3); pc.printf("[esp]\t: %s \n\r", rx_buf);
    esp.printf("if global_c ~= nil then global_c:close() end \n\r"); get_reply(3); pc.printf("[esp]\t: %s \n\r", rx_buf);
    esp.printf("global_c = c \n\r"); get_reply(3); pc.printf("[esp]\t: %s \n\r", rx_buf);
    esp.printf("c:on(\"receive\", function(sck, pl) \n\r"); get_reply(3); pc.printf("[esp]\t: %s \n\r", rx_buf);
    esp.printf("uart.write(0, \"REQUEST\") \n\r"); get_reply(3); pc.printf("[esp]\t: %s \n\r", rx_buf);
    esp.printf("end) end) \n\r"); get_reply(3); pc.printf("[esp]\t: %s \n\r", rx_buf);

    pc.printf("\n\r[mbed]\t: setting up serial comm ... \n\r");   pc.printf("[esp]\t: %s \n\r", rx_buf);  
    esp.printf("uart.setup(0, 9600, 8, 0, 1, 1) \n\r"); get_reply(10); pc.printf("[esp]\t: %s \n\r", rx_buf);
    esp.printf("uart.on(\"data\", 0, function(data) \n\r"); get_reply(10); pc.printf("[esp]\t: %s \n\r", rx_buf);
    esp.printf("if global_c ~= nil then \n\r"); get_reply(3); pc.printf("[esp]\t: %s \n\r", rx_buf);
    esp.printf("global_c:send(\"<html><h1>\" .. data .. \"</h1></html>\") \n\r"); get_reply(3); pc.printf("[esp]\t: %s \n\r", rx_buf);
    esp.printf("global_c:close()\n\r end end, 0)\n\r"); get_reply(3); pc.printf("[esp]\t: %s \n\r", rx_buf);
   
    
    esp.printf("start_seq = 1 \n\r");
    get_reply(10);
    memset(rx_buf, '\0', sizeof(rx_buf));

    esp.attach(&esp_handler, Serial::RxIrq);
    pc.printf("\n\r[mbed]\t: READY \n\n\r");

    while (1) { sleep(); }

}

void get_reply(int timeout)
{
    memset(rx_buf, '\0', sizeof(rx_buf));
    t.start();
    int ended = 0;
    int count = 0;
    while(!ended)
    {
        if (esp.readable())
        {
            rx_buf[count++] = esp.getc();
        }
        if(t.read() > timeout) {
            ended = 1;
            t.stop();
            t.reset();
        }
    }   
}

void esp_handler(void)
{
    char c = esp.getc();
    pc.putc(c);
    if (c == '\0') pc.printf("\n\r");
    esp.putc(id);
    id++;
    if (id == 58) id = 48;

}
