#ifndef SRF02_H
#define SRF02_H

#include "mbed.h"



class SRF02
{
public:
  //!Creates an instance of the class.
  /*!
  Connect module at I2C address addr using I2C port pins sda and scl.
  SRF08
  */
  SRF02(PinName sda, PinName scl, int addr);
  
  /*!
  Destroys instance.
  */ 
  ~SRF02();
  
  
  int readcm();     //Read the range data in centimeters
 
  int readinch();   //Read the range data in inches
  
  void change_addr(char new_addr);      //Change the adress of the device. This is very usefull when there are more sensors.
                                        //This function must be executed with only one sensor conected.
  
  
private:
  I2C m_i2c;
  int m_addr;

};

#endif