/**
 * @file
 * Websocket server sample.<br/>
 * This program is websocket server template.
 * 
 */
#include "mbed.h"
#include "rtos.h"
#include "SDFileSystem.h"
#include "mimic.h"
#include "utils/PlatformInfo.h"
#include "fsdata.h"


//local filesystem
LocalFileSystem2 lf("local");

NetConfig cfg; //create network configulation
Net* net;

/**
 * Httpd for UPnPService and presentation.
 */
class WebSocketHttpd:public MiMic::Httpd
{
private:
    ModLocalFileSystem modlocal;
    ModWebSocket modwebsocket;
    ModRomFiles modromfs; //ROM file module    
public:
    WebSocketHttpd(NetConfig& i_cfg):Httpd(i_cfg.getHttpPort())
    {
        //prepare fs data (presentation.html,icon,image.)
        this->modromfs.setParam("rom",FSDATA,3);
        this->modlocal.setParam("local");
        //bind websocket module.
        this->modwebsocket.setParam("ws");
    }
    virtual void onRequest(HttpdConnection& i_connection)
    {
        //try to ModRomFS module. for icon,images.
        if(this->modromfs.execute(i_connection)){
            return;
        }
        //try to ModLocalFileSystem
        if(this->modlocal.execute(i_connection)){
            return;
        }
        //try to Websocket service.
        if(this->modwebsocket.execute(i_connection)){
            //send AIN1 value every 10ms.
            AnalogIn ain(p20);
            do{
                Thread::wait(20);
            }while(this->modwebsocket.writeFormat("%d,",(int)(ain*4096)));
            this->modwebsocket.close();
            return;
        }
        //Otherwise, Send the redirect response to /rom/index.html
        i_connection.sendHeader(302,
            "text/html",
            "Status: 302:Moved Temporarily\r\n"
            "Location: /rom/index.html\r\n");     
    }
};


int main()
{
    MiMicNetIf netif;
    net=new Net(netif);//Net constructor must be created after started RTOS
    // manual setting
    cfg.setIpAddr(192,168,128,39);
    cfg.setNetMask(255,255,255,0);
    cfg.setGateway(192,168,128,254);    
    //cfg.setSrvUPnP(false);
    cfg.setSrvMdns(false);
    
    WebSocketHttpd httpd(cfg); //create a httpd instance.
    net->start(cfg);
    httpd.loop();  //start httpd loop.
    return 0;
}
