/**
 * @file
 * Simplest UPnP basic device.<br/>
 * This program is upnp:BasicDeveice:1 template.
 * 
 * <p>
 * After starting program, check "network" by Exproler.
 * MiMic basic device will be appeared.
 * </p>
 */
#include "mbed.h"
#include "rtos.h"
#include "SDFileSystem.h"
#include "mimic.h"
#include "utils/PlatformInfo.h"
#include "fsdata.h"



/**
 * Httpd for UPnPService and presentation.
 */
class UPnPBasicDeviceHttpd:public MiMic::Httpd
{
private:
    ModUPnPDevice modupnp;
    ModRomFiles modromfs; //ROM file module    
public:
    UPnPBasicDeviceHttpd(Net& net,NetConfig& i_cfg):Httpd(i_cfg.getHttpPort())
    {
        //prepare fs data (presentation.html,icon,image.)
        this->modromfs.setParam("rom",FSDATA,3);
        //bind upnp service to module.
        this->modupnp.setParam(net);
    }
    virtual void onRequest(HttpdConnection& i_connection)
    {
        //try to ModRomFS module. for icon,images.
        if(this->modromfs.execute(i_connection)){
            return;
        }        
        //try to UPnP service. for descriptions.
        if(this->modupnp.execute(i_connection)){
            return;
        }
        //Otherwise, Send the redirect response to /rom/index.html
        i_connection.sendHeader(302,
            "text/html",
            "Status: 302:Moved Temporarily\r\n"
            "Location: /rom/index.html\r\n");     
    }
};

UPnPBasicDeviceHttpd* httpd;
int main()
{
    MiMicNetIf netif;
    NetConfig cfg; //create network configulation
    Net net(netif);//Net constructor must be created after started RTOS

    //Prepare configulation.
    cfg.setUPnPIcon(64,64,8,"image/png","/rom/icon.png");//set upnp icon address
    cfg.setUPnPUdn(0xe29f7103,0x4ba2,0x01e0,0); //set application timebase-uuid time and sequence field.
    cfg.setFriendlyName("UPnPBasicDevice(LPC176x)"); //set friendly name
    cfg.setUPnPPresentationURL("/rom/index.html"); //set presentationURL
    cfg.setZeroconf(true);//AutoIP enable
    
    /*
    DHCP client has a bug which can not  obtain IP address from a DHCP server.
    In that case, please turn off setZeroconf and give an IP address manually as temporary solution. 
    cfg.setIpAddr(1,2,3,4);
    cfg.setNetMask(1,2,3,4);
    cfg.setGateway(1,2,3,4);
    */
    

    httpd=new UPnPBasicDeviceHttpd(net,cfg); //create a httpd instance.
    net.start(cfg);
    httpd->loop();  //start httpd loop.
    return 0;
}
