/**
 * @file
 * TCP client socket sample.<br/>
 * This program is to test of TCP client.
 * Connect to a TCP server, and send back the received data as is.
 * 
 */
#include "mbed.h"
#include "rtos.h"
#include "SDFileSystem.h"
#include "mimic.h"
#include "utils/PlatformInfo.h"
#include "fsdata.h"


NetConfig cfg; //create network configulation
Net* net;

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);


int main()
{
    MiMicNetIf netif;
    Net net(netif);//Net constructor must be created after started RTOS
    NetConfig cfg; //create network configulation
    // manual setting
    cfg.setIpAddr(192,168,128,39);
    cfg.setNetMask(255,255,255,0);
    cfg.setGateway(192,168,128,254);    
    cfg.setSrvUPnP(false);
    cfg.setSrvMdns(false);

    // Create tcp socket with 512 bytes RX buffer.
    // Socket must create between "net.start" with "new Net()"
    TcpSocket* socket=new TcpSocket();
    
    //Start network
    net.start(cfg);


    led1=1;    
    for(;;){
        //connect to server
        if(!socket->connect(IpAddr(192,168,128,195),1234)){
            Thread::wait(1000);
        }
        //connected!
        led2=1;
        for(;;){
            led4=0;
            led3=1;
            //wait for data...
            const void* rx;
            //get read pointer
            int l=socket->precv(rx);
            if(l<0){
                break;
            }
            if(l==0){
                //timeout
            }else{
                //ok,echo back data.
                led4=1;
                //send data
                if(!socket->send(rx,l)){
                    break;
                }
                //move read pointer.
                socket->pseek(l);
            }
            led3=0;
        }
        led2=0;
        led3=0;
        led4=0;
        socket->close(); //close the socket.
    }
    return 0;
}

