#include "mimic.h"
#include "mbed.h"
#include "InOut.h"
#include "fsdata.h"

LocalFileSystem2 lf("local");


class RedIoPin: public InOut
{
private:
    bool _v_pin;
    bool _v_rs;
public:
    RedIoPin(char pin):InOut(pin,0)
    {
        //pull down
        this->mode(1);//pull down
        //read from pin
        this->setDirection(true);
        this->write(0);
        this->setDirection(false);        
        //initialize pin and rs
        this->_v_pin=this->read()!=0;
        this->_v_rs=false;
    }
    /**
     * set RedStoneValue RedStone value
     * @param v
     * red stone value
     * @return
     * current pin value
     */
    bool setRedValue(int v)
    {
        //update red stone pattern
        this->_v_rs=(v!=0);
        
        //check pin value
        this->setDirection(true);
        this->write(0);
        this->setDirection(false);
        this->_v_pin=(this->read()!=0);
        
        //mix two values
        if(this->_v_pin){
            // set pin to Lv=H,dir=in
            if(this->_v_rs){
                //pin==1 && rs==1
                this->setDirection(true);
                this->write(1);
            }else{
                //pin==1 && rs==0
                this->write(0);
            }
        }else{
            if(this->_v_rs){
                //pin==0 && rs==1
                this->setDirection(true);
                this->write(1);
            }else{
                //pin==0 && rs==0
                this->write(0);
            }
        }
        //actual pin value
        return this->_v_pin;
    }
};
class RedIo
{
public:
    RedIoPin* io[30];
    RedIo()
    {
        const char d[]={LED1,LED2,LED3,LED4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30};
        for(int i=0;i<30;i++){
            this->io[i]=new RedIoPin(d[i]);
        }
    }
    virtual ~RedIo()
    {
        for(int i=0;i<30;i++){
            delete this->io[i];
        }
    }
    unsigned int update(unsigned int v)
    {
        unsigned int ret=0;
        for(int i=0;i<30;i++){
            ret=ret<<1;
            ret=ret | ((this->io[29-i]->setRedValue((v>>(29-i))&0x00000001))?1:0);
        }
        return ret;
    }
};

Net* net;

class RedWireBridge:public MiMic::Httpd
{
private:
    ModUrl modurl; //basic URL parser
    ModRomFiles modromfs; //ROM file module
    ModUPnPDevice modupnp;
    RedIo rsio;
public:
    RedWireBridge(NetConfig& i_cfg):Httpd(i_cfg.getHttpPort())
    {
        this->modromfs.setParam("rom",FSDATA,3);
        //bind upnp service to module.
        this->modupnp.setParam(*net);
    }
    virtual void onRequest(HttpdConnection& i_connection)
    {
        char url[64];
        int method;
        //try to ModRomFS module. for icon,images.
        if(this->modromfs.execute(i_connection)){
            return;
        }        
        //try to UPnP service. for descriptions.
        if(this->modupnp.execute(i_connection)){
            return;
        }
        //rsb CGI 
        
        
        //call ModUrl module.
        if(!this->modurl.execute(i_connection,url,64,&method)){
            i_connection.sendHeader(400,"text/html",NULL);
            i_connection.sendBodyF("<html><body>Bad Request.</body></html>",url);
            return;
        }
        UrlReader r(url);
        if(!r.isPathEqual("/rsb/")){
            i_connection.sendHeader(403,"text/html",NULL);
            i_connection.sendBodyF("<html><body>Path must be '/rsb/?p=[:unsigned int:]'</body></html>",url);
            return;
        }
        unsigned int rsv;
        if(!r.getQueryUInt("p",rsv)){
            i_connection.sendHeader(400,"text/html",NULL);
            i_connection.sendBodyF("<html><body>p val must be unsigned int</body></html>",url);
            return;
        }
        i_connection.sendHeader(200,"text/html",NULL);
        i_connection.sendBodyF("%u",rsio.update(rsv));
        return;
    }
};

int main()
{
    net=new Net();  //create a net instance.
    NetConfig cfg; //create network configulation
    //Prepare configulation.
    cfg.setUPnPIcon(64,64,8,"image/png","/rom/icon.png");//set upnp icon address
    cfg.setUPnPUdn(0x0c9720e0,0x031e,0x11e3,0); //set application timebase-uuid time and sequence field.
    cfg.setFriendlyName("RedWireBridge"); //set friendly name
    cfg.setUPnPPresentationURL("/rom/index.html"); //set presentationURL
    cfg.setZeroconf(true);//AutoIP enable
 
    //try to override setting by local file.
    cfg.loadFromFile("/local/mimic.cfg");

    RedWireBridge httpd(cfg); //create a httpd instance.
    net->start(cfg);
    httpd.loop();  //start httpd loop.
    return 0;
}
