/* Copyright (C) 2014 Murata Manufacturing Co.,Ltd., MIT License
 *  muRata, SWITCH SCIENCE Wi-FI module TypeYD SNIC-UART.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 * and associated documentation files (the "Software"), to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
/**
 * modified by nyatlan
 * Simplest Murata TypeYD ping server.
 */
#include "mbed.h"
#include "SNIC_WifiInterface.h"

/**
 * Wifi AP parameter
 */
#define DEMO_AP_SSID                  "WIFI_SSID"
#define DEMO_AP_SECURITY_TYPE         e_SEC_WPA2_MIXED
#define DEMO_AP_SECUTIRY_KEY          "WIFI_KEY"

/** Wi-Fi SNIC UART Interface*/
#if defined(TARGET_LPC1768)
C_SNIC_WifiInterface     mSNICwifi( p9, p10, NC, NC, p30 );
#elif defined(TARGET_KL46Z)
C_SNIC_WifiInterface     mSNICwifi( D1, D0, NC, NC, D3 );
#endif

int main()
{
    // Initialize Wi-Fi interface
    if(mSNICwifi.init()!=0){
        mbed_die();
    }
    wait(0.5);
    if(mSNICwifi.disconnect()!= 0 )
    {
        mbed_die();
    }    
    wait(0.3);

    // Connect AP
    if(mSNICwifi.connect( DEMO_AP_SSID, strlen(DEMO_AP_SSID), DEMO_AP_SECURITY_TYPE, DEMO_AP_SECUTIRY_KEY, strlen(DEMO_AP_SECUTIRY_KEY))!=0)
    {
        mbed_die();
    }
    wait(0.5);

    //update IP configuration
    mSNICwifi.setIPConfig(false,"192.168.128.39","255.255.255.0","192.168.128.254");

    DigitalOut led1(LED1);
    led1=1;
    
    //OK. you can do ping to Wifi address.
    for(;;){
        wait(1);
    }
}
