#include "mimic.h"
 
 LocalFileSystem2 lf("local");

/**
 * This program is simplest httpd.
 * The program echo back yuor request in html.
 */
class SimpleHttpd:public MiMic::Httpd
{
private:
    ModUrl modurl; //basic URL parser
public:
    SimpleHttpd(NetConfig& i_cfg):Httpd(i_cfg.getHttpPort())
    {
    }
    virtual void onRequest(HttpdConnection& i_connection)
    {
        char url[32];
        int method;
        
        //
        //write Http handler(s) here!
        //
        
        //call ModUrl module.
        if(this->modurl.execute(i_connection,url,32,&method)){
            //send 200 OK and requested URL
            i_connection.sendHeader(200,"text/html",NULL);
            i_connection.sendBodyF("<html><body>Your Request path is %s.</body></html>",url);
            return;
        }
        
        return;
    }
};

NetConfig cfg; //create network configulation
int main()
{
    Net net;  //create a net instance.

    //try to override setting by local file.
    cfg.loadFromFile("/local/mimic.cfg");
    cfg.setSrvUPnP(false);//disable UPnP
    cfg.setSrvMdns(false);//disable mDNS
    
    SimpleHttpd httpd(cfg); //create a httpd instance.
    net.start(cfg);
    httpd.loop();  //start httpd loop.
    return 0;
}
 