/**
 * @file
 * TCP client socket sample.<br/>
 * This program is to test of TCP client.
 * Connect to a TCP server, and send back the received data as is.
 * 
 */
#include "mbed.h"
#include "rtos.h"
#include "SDFileSystem.h"
#include "mimic.h"
#include "utils/PlatformInfo.h"
#include "fsdata.h"

LocalFileSystem2 lf("local");

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

    MiMicNetIf netif;
    NetConfig cfg; //create network configulation  with onchip-setting.

int main()
{
    Net net(netif);//Net constructor must be created after started RTOS

    // manual setting
    cfg.setIpAddr(192,168,128,39);
    cfg.setNetMask(255,255,255,0);
    cfg.setGateway(192,168,128,254);    
    cfg.setSrvUPnP(false);
    cfg.setSrvMdns(false);

    // Create http client.
    // Socket must create between "net.start" with "new Net()"
    HttpClient http;
led1=1;
    
    //Start network
    net.start(cfg);
led2=2;
    if(http.connect(IpAddr(192,168,128,1),80)){
        if(http.sendMethod(HttpClient::HTTP_GET,"/mimic/")){            
            FILE *fp=fopen("/local/out.txt", "w");
            if(fp!=NULL){            
                int s=http.getStatus();
                fprintf(fp, "Status:%d\n",s);
                if(s==200){
                    for(;;){
                        short l;
                        char b[32];
                        if(!http.read(b,32,l)){
                            //Error
                            led1=1;
                            break;
                        }
                        if(fwrite(b,1,l,fp)<l){
                            //EOS
                            led2=1;
                            break;
                        }
                        if(l==0){
                            //EOS
                            led3=1;
                            break;
                        }
                    }
                }            
                fclose(fp);
            }
        }
        http.close();
    }
    if(http.connect(IpAddr(192,168,128,254),80)){
        if(http.sendMethod(HttpClient::HTTP_POST,"/mimic/")){
            const char* DATA="{json}";
            if(http.write(DATA,strlen(DATA))){
                if(http.getStatus()==200){
                    char buf[256];
                    short len;
                    if(http.read(buf,256,len)){
                        printf("%.*s",len,buf);
                    }
                }
            }
        }
        http.close();
    }    
    for(int c=0;;c=(c+1)%2){
        led4=c;
        Thread::wait(500);
    }
    return 0;
}

