#include "mimic.h"
#include "rtos.h"
/**
 * @file
 * This program is a sample which starts httpd by a subtask.
 * The value counted up by a main thread is returned by Httpd of a subtask.
 */
 
 
static unsigned int counter=0;


LocalFileSystem2 lf("local");
class AsyncHttpd:public MiMic::Httpd
{
private:
    ModUrl modurl; //basic URL parser
public:
    AsyncHttpd(NetConfig& i_cfg):Httpd(i_cfg.getHttpPort())
    {
    }
    virtual void onRequest(HttpdConnection& i_connection)
    {
        char url[32];
        int method;
        unsigned int v;
        i_connection.lockHttpd();
        v=counter;
        i_connection.unlockHttpd();
        

        //call ModUrl module.
        if(this->modurl.execute(i_connection,url,32,&method)){
            //send 200 OK and requested URL
            i_connection.sendHeader(200,"text/html",NULL);
            //show current counter value.
            i_connection.sendBodyF(
                "<html><body><h1>Asynchronous test</h1><div>Counter: %u</body></html>",v);
            return;
        }
        
        return;
    }
};

    MiMicNetIf netif;
NetConfig cfg; //create network configulation
int main()
{
    Net net(netif);//Net constructor must be created after started RTOS


    //try to override setting by local file.
    cfg.loadFromFile("/local/mimic.cfg");
    
    AsyncHttpd httpd(cfg); //create a httpd instance.
    net.start(cfg);
    httpd.loopTask();  //start httpd loop with new task
    for(;;){
        httpd.lock();//prepare to access shared resource
        counter++;
        httpd.unlock();//release a lock.
        Thread::wait(1000);
    }
    return 0;
}
 