#include "mbed.h"
#include "LPS331_I2C.h"

Serial pc(USBTX, USBRX);
LPS331_I2C lps331(p9, p10, LPS331_I2C_SA0_HIGH);


int main() {
    pc.printf("LPS331 Test Program.\r\n");
    
    if(lps331.isAvailable()) {
        pc.printf("LPS331 is available!\r\n");
    } else {
        pc.printf("LPS331 is unavailable!\r\n");
    }
    
    lps331.setResolution(LPS331_I2C_PRESSURE_AVG_512, LPS331_I2C_TEMP_AVG_128);
    lps331.setDataRate(LPS331_I2C_DATARATE_7HZ);
    lps331.setActive(true);
    
    pc.printf("LPS331 Register map.\r\n");

    for(int i = 0; i < 8; i++) {
        pc.printf("%02x: ", i);
        for(int j = 0; j < 16; j++) {
            char value = lps331._read(j | i << 4);
            pc.printf("%02x ", value);
        }
        pc.printf("\r\n");
    }
    
    pc.printf("LPS331 Register map(multibyte read test).\r\n");
    
    for(int i = 0; i < 8; i++) {
        char data[16];
        lps331._read_multibyte(i << 4, data, 16);
        pc.printf("%02x: ", i);
        for(int j = 0; j < 16; j++) {
            pc.printf("%02x ", data[j]);
        }
        pc.printf("\r\n");
    }
    
    wait(2.0);
                
    while(true) {
        float pres, temp;
        
        pres = lps331.getPressure();
        temp = lps331.getTemperature();
        
        pc.printf("%f,%f\r\n", pres, temp);
        
        wait(1/7.0);
    }

}
